/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rmi;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.rmi.RmiEndpoint;
import org.apache.camel.component.rmi.RmiRegistryBean;
import org.apache.camel.support.DefaultProducer;

public class RmiProducer
extends DefaultProducer {
    private BeanProcessor beanProcessor;

    public RmiProducer(RmiEndpoint endpoint) throws RemoteException, NotBoundException {
        super((Endpoint)endpoint);
        RmiRegistryBean holder = new RmiRegistryBean(endpoint.getCamelContext(), endpoint.getName(), endpoint.getRegistry());
        this.beanProcessor = new BeanProcessor((BeanHolder)holder);
        String method = endpoint.getMethod();
        if (method != null) {
            this.beanProcessor.setMethod(method);
        }
    }

    public void process(Exchange exchange) throws Exception {
        this.beanProcessor.process(exchange);
    }
}

