/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sns;

import com.amazonaws.regions.Regions;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.sns.SnsComponentVerifierExtension;
import org.apache.camel.component.aws.sns.SnsConfiguration;
import org.apache.camel.component.aws.sns.SnsEndpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="aws-sns")
public class SnsComponent
extends DefaultComponent {
    @Metadata
    private String accessKey;
    @Metadata
    private String secretKey;
    @Metadata
    private String region;
    @Metadata(label="advanced")
    private SnsConfiguration configuration = new SnsConfiguration();

    public SnsComponent() {
        this(null);
    }

    public SnsComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new SnsComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SnsConfiguration configuration = this.configuration.copy();
        this.setProperties(configuration, parameters);
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Topic name must be specified.");
        }
        if (remaining.startsWith("arn:")) {
            String[] parts = remaining.split(":");
            if (parts.length != 6 || !parts[2].equals("sns")) {
                throw new IllegalArgumentException("Topic arn must be in format arn:aws:sns:region:account:name.");
            }
            configuration.setTopicArn(remaining);
            configuration.setRegion(Regions.fromName((String)parts[3]).toString());
        } else {
            configuration.setTopicName(remaining);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getAccessKey())) {
            this.setAccessKey(this.accessKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getSecretKey())) {
            this.setSecretKey(this.secretKey);
        }
        if (ObjectHelper.isEmpty((Object)configuration.getRegion())) {
            this.setRegion(this.region);
        }
        if (configuration.getAmazonSNSClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonSNSClient or accessKey and secretKey must be specified");
        }
        SnsEndpoint endpoint = new SnsEndpoint(uri, (Component)this, configuration);
        return endpoint;
    }

    public SnsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SnsConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAccessKey() {
        return this.configuration.getAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.configuration.setAccessKey(accessKey);
    }

    public String getSecretKey() {
        return this.configuration.getSecretKey();
    }

    public void setSecretKey(String secretKey) {
        this.configuration.setSecretKey(secretKey);
    }

    public String getRegion() {
        return this.configuration.getRegion();
    }

    public void setRegion(String region) {
        this.configuration.setRegion(region);
    }
}

