/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.policy;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.component.zookeeper.policy.CuratorLeaderElection;
import org.apache.camel.component.zookeeper.policy.ElectionWatcher;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.RoutePolicySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorLeaderRoutePolicy
extends RoutePolicySupport
implements ElectionWatcher,
NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorLeaderRoutePolicy.class);
    private final String uri;
    private final Lock lock = new ReentrantLock();
    private final Set<Route> suspendedRoutes = new CopyOnWriteArraySet<Route>();
    private final AtomicBoolean shouldProcessExchanges = new AtomicBoolean();
    private volatile boolean shouldStopRoute = true;
    private final Lock electionLock = new ReentrantLock();
    private CuratorLeaderElection election;

    public CuratorLeaderRoutePolicy(String uri) {
        this.uri = uri;
    }

    public CuratorLeaderRoutePolicy(CuratorLeaderElection election) {
        this.election = election;
        this.uri = null;
    }

    public void onInit(Route route) {
        this.ensureElectionIsCreated(route);
        LOG.info("Route managed by {}. Setting route {} AutoStartup flag to false.", this.getClass(), (Object)route.getId());
        RouteDefinition definition = (RouteDefinition)route.getRouteContext().getRoute();
        definition.setAutoStartup("false");
        this.ensureElectionIsCreated(route);
        if (this.election.isMaster()) {
            if (this.shouldStopRoute) {
                this.startManagedRoute(route);
            }
        } else if (this.shouldStopRoute) {
            this.stopManagedRoute(route);
        }
    }

    private void ensureElectionIsCreated(Route route) {
        if (this.election == null) {
            this.electionLock.lock();
            try {
                if (this.election == null) {
                    this.election = new CuratorLeaderElection(route.getRouteContext().getCamelContext(), this.uri);
                    this.election.addElectionWatcher(this);
                }
            }
            finally {
                this.electionLock.unlock();
            }
        }
    }

    private void startManagedRoute(Route route) {
        try {
            this.lock.lock();
            if (this.suspendedRoutes.contains(route)) {
                this.startRoute(route);
                this.suspendedRoutes.remove(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void stopManagedRoute(Route route) {
        try {
            this.lock.lock();
            if (!this.suspendedRoutes.contains(route) && !this.shouldProcessExchanges.get()) {
                this.stopRoute(route);
                this.suspendedRoutes.add(route);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void electionResultChanged() {
        if (this.election.isMaster()) {
            this.startAllStoppedRoutes();
        }
    }

    private void startAllStoppedRoutes() {
        try {
            this.lock.lock();
            if (!this.suspendedRoutes.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} route(s) have been stopped previously by policy, restarting.", (Object)this.suspendedRoutes.size());
                }
                for (Route suspended : this.suspendedRoutes) {
                    this.log.debug("Starting route {}.", (Object)suspended.getId());
                    this.startRoute(suspended);
                }
                this.suspendedRoutes.clear();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void doShutdown() throws Exception {
        this.election.shutdownClients();
    }
}

