/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.policy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.StatefulService;
import org.apache.camel.component.zookeeper.policy.ElectionWatcher;
import org.apache.camel.impl.JavaUuidGenerator;
import org.apache.camel.spi.UuidGenerator;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorLeaderElection {
    private static final Logger LOG = LoggerFactory.getLogger(CuratorLeaderElection.class);
    private final CamelContext camelContext;
    private final String uri;
    private final String candidateName;
    private final Lock lock = new ReentrantLock();
    private final CountDownLatch electionComplete = new CountDownLatch(1);
    private final List<ElectionWatcher> watchers = new ArrayList<ElectionWatcher>();
    private AtomicBoolean masterNode = new AtomicBoolean(false);
    private volatile boolean isCandidateCreated;
    private int enabledCount = 1;
    private UuidGenerator uuidGenerator = new JavaUuidGenerator();
    private LeaderSelector leaderSelector;
    private CuratorFramework client;

    public CuratorLeaderElection(CamelContext camelContext, String uri) {
        this.camelContext = camelContext;
        this.uri = uri;
        this.candidateName = this.createCandidateName();
        String connectionString = uri.substring(1 + uri.indexOf(58)).split("/")[0];
        String protocol = uri.substring(0, uri.indexOf(58));
        String path = uri.replace(protocol + ":" + connectionString, "");
        this.client = CuratorFrameworkFactory.newClient((String)connectionString, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        this.client.start();
        this.leaderSelector = new LeaderSelector(this.client, path, (LeaderSelectorListener)new CamelLeaderElectionListener());
        this.leaderSelector.start();
    }

    public static boolean isCamelStopping(CamelContext context) {
        if (context instanceof StatefulService) {
            StatefulService ss = (StatefulService)context;
            return ss.isStopping() || ss.isStopped();
        }
        return false;
    }

    public void shutdownClients() {
        try {
            this.leaderSelector.close();
        }
        finally {
            this.client.close();
        }
    }

    public boolean isMaster() {
        return this.masterNode.get();
    }

    private String createCandidateName() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException ex) {
            LOG.warn("Failed to get the local hostname.", (Throwable)ex);
            builder.append("unknown-host");
        }
        builder.append("-").append(this.uuidGenerator.generateUuid());
        return builder.toString();
    }

    public String getCandidateName() {
        return this.candidateName;
    }

    private void notifyElectionWatchers() {
        for (ElectionWatcher watcher : this.watchers) {
            try {
                watcher.electionResultChanged();
            }
            catch (Exception e) {
                LOG.warn("Election watcher " + watcher + " of type " + watcher.getClass() + " threw an exception.", (Throwable)e);
            }
        }
    }

    public boolean addElectionWatcher(ElectionWatcher e) {
        return this.watchers.add(e);
    }

    class CamelLeaderElectionListener
    extends LeaderSelectorListenerAdapter {
        CamelLeaderElectionListener() {
        }

        public void takeLeadership(CuratorFramework curatorFramework) throws Exception {
            CuratorLeaderElection.this.masterNode.set(true);
            LOG.info("{} is now leader", (Object)CuratorLeaderElection.this.getCandidateName());
            CuratorLeaderElection.this.notifyElectionWatchers();
            while (!CuratorLeaderElection.isCamelStopping(CuratorLeaderElection.this.camelContext)) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    break;
                }
            }
            CuratorLeaderElection.this.masterNode.set(false);
            LOG.info("{} has given up its own leadership", (Object)CuratorLeaderElection.this.getCandidateName());
            CuratorLeaderElection.this.notifyElectionWatchers();
        }
    }
}

