/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.directmessage;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.AbstractTwitterConsumerHandler;
import org.apache.camel.component.twitter.consumer.TwitterEventType;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageList;
import twitter4j.TwitterException;

public class DirectMessageConsumerHandler
extends AbstractTwitterConsumerHandler {
    public DirectMessageConsumerHandler(TwitterEndpoint te) {
        super(te);
    }

    @Override
    public List<Exchange> pollConsume() throws TwitterException {
        DirectMessageList directMessages = this.getTwitter().getDirectMessages(this.endpoint.getProperties().getCount().intValue());
        for (int i = 0; i < directMessages.size(); ++i) {
            this.setLastIdIfGreater(((DirectMessage)directMessages.get(i)).getId());
        }
        return TwitterEventType.DIRECT_MESSAGE.createExchangeList(this.endpoint, directMessages);
    }

    @Override
    public List<Exchange> directConsume() throws TwitterException {
        return TwitterEventType.DIRECT_MESSAGE.createExchangeList(this.endpoint, this.getTwitter().getDirectMessages(this.endpoint.getProperties().getCount().intValue()));
    }
}

