/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.model.GenericMessage;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.hl7.HL7GenericMessageConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

public class HL7GenericMessageConverterLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(18);

    private void registerConverters() {
        this.converters.put(GenericMessage.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toGenericMessage((byte[])value, exchange);
            }
        });
        this.converters.put(GenericMessage.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toGenericMessage((String)value);
            }
        });
        this.converters.put(GenericMessage.V21.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV21GenericMessage((byte[])value, exchange);
            }
        });
        this.converters.put(GenericMessage.V21.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV21GenericMessage((String)value);
            }
        });
        this.converters.put(GenericMessage.V22.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV22GenericMessage((byte[])value, exchange);
            }
        });
        this.converters.put(GenericMessage.V22.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV22GenericMessage((String)value);
            }
        });
        this.converters.put(GenericMessage.V23.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV23GenericMessage((byte[])value, exchange);
            }
        });
        this.converters.put(GenericMessage.V23.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV23GenericMessage((String)value);
            }
        });
        this.converters.put(GenericMessage.V231.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV231GenericMessage((byte[])value, exchange);
            }
        });
        this.converters.put(GenericMessage.V231.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV231GenericMessage((String)value);
            }
        });
        this.converters.put(GenericMessage.V24.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV24GenericMessage((byte[])value, exchange);
            }
        });
        this.converters.put(GenericMessage.V24.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV24GenericMessage((String)value);
            }
        });
        this.converters.put(GenericMessage.V25.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV25GenericMessage((byte[])value, exchange);
            }
        });
        this.converters.put(GenericMessage.V25.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV25GenericMessage((String)value);
            }
        });
        this.converters.put(GenericMessage.V251.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV251GenericMessage((byte[])value, exchange);
            }
        });
        this.converters.put(GenericMessage.V251.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV251GenericMessage((String)value);
            }
        });
        this.converters.put(GenericMessage.V26.class, byte[].class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV26GenericMessage((byte[])value, exchange);
            }
        });
        this.converters.put(GenericMessage.V26.class, String.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return HL7GenericMessageConverter.toV26GenericMessage((String)value);
            }
        });
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

