/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.parser.UnexpectedSegmentBehaviourEnum;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.io.IOException;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;

@Converter(loader=true)
public final class HL7Converter {
    private static final HapiContext DEFAULT_CONTEXT;

    private HL7Converter() {
    }

    @Converter
    public static String toString(Message message) throws HL7Exception {
        return message.encode();
    }

    @Converter
    public static byte[] toByteArray(Message message, Exchange exchange) throws HL7Exception, IOException {
        return IOConverter.toByteArray((String)message.encode(), (Exchange)exchange);
    }

    @Converter
    public static Message toMessage(String body) throws HL7Exception {
        return DEFAULT_CONTEXT.getGenericParser().parse(body);
    }

    @Converter
    public static Message toMessage(byte[] body, Exchange exchange) throws HL7Exception, IOException {
        return DEFAULT_CONTEXT.getGenericParser().parse(IOConverter.toString((byte[])body, (Exchange)exchange));
    }

    static {
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setDefaultObx2Type("ST");
        parserConfiguration.setInvalidObx2Type("ST");
        parserConfiguration.setUnexpectedSegmentBehaviour(UnexpectedSegmentBehaviourEnum.ADD_INLINE);
        DEFAULT_CONTEXT = new DefaultHapiContext(parserConfiguration, ValidationContextFactory.noValidation(), (ModelClassFactory)new DefaultModelClassFactory());
    }
}

