/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cmis.CMISComponent;
import org.apache.camel.component.cmis.CMISConsumer;
import org.apache.camel.component.cmis.CMISProducer;
import org.apache.camel.component.cmis.CMISQueryProducer;
import org.apache.camel.component.cmis.CMISSessionFacade;
import org.apache.camel.component.cmis.CMISSessionFacadeFactory;
import org.apache.camel.component.cmis.DefaultCMISSessionFacadeFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.11.0", scheme="cmis", title="CMIS", syntax="cmis:cmsUrl", label="cms,database")
public class CMISEndpoint
extends DefaultEndpoint {
    @UriPath(description="URL to the cmis repository")
    @Metadata(required=true)
    private final String cmsUrl;
    @UriParam(label="producer")
    private boolean queryMode;
    @UriParam
    private CMISSessionFacade sessionFacade;
    @UriParam(label="advanced")
    private CMISSessionFacadeFactory sessionFacadeFactory;
    private Map<String, Object> properties;

    public CMISEndpoint(String uri, CMISComponent component, String cmsUrl) {
        this(uri, component, cmsUrl, new DefaultCMISSessionFacadeFactory());
    }

    public CMISEndpoint(String uri, CMISComponent component, String cmsUrl, CMISSessionFacadeFactory sessionFacadeFactory) {
        super(uri, (Component)component);
        this.cmsUrl = cmsUrl;
        this.sessionFacadeFactory = sessionFacadeFactory;
    }

    public Producer createProducer() throws Exception {
        return this.queryMode ? new CMISQueryProducer(this, this.sessionFacadeFactory) : new CMISProducer(this, this.sessionFacadeFactory);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CMISConsumer consumer = new CMISConsumer(this, processor, this.sessionFacadeFactory);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(boolean queryMode) {
        this.queryMode = queryMode;
    }

    public String getCmsUrl() {
        return this.cmsUrl;
    }

    public CMISSessionFacade getSessionFacade() {
        return this.sessionFacade;
    }

    public void setSessionFacade(CMISSessionFacade sessionFacade) {
        this.sessionFacade = sessionFacade;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public CMISSessionFacadeFactory getSessionFacadeFactory() {
        return this.sessionFacadeFactory;
    }

    public void setSessionFacadeFactory(CMISSessionFacadeFactory sessionFacadeFactory) {
        this.sessionFacadeFactory = sessionFacadeFactory;
    }
}

