/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sparkrest;

import spark.Route;
import spark.Spark;

public final class CamelSpark {
    private CamelSpark() {
    }

    public static void stop() {
        Spark.stop();
    }

    public static void port(int port) {
        Spark.port((int)port);
    }

    public static void ipAddress(String ip) {
        Spark.ipAddress((String)ip);
    }

    public static void threadPool(int minThreads, int maxThreads, int timeOutMillis) {
        int min = minThreads > 0 ? minThreads : -1;
        int max = maxThreads > 0 ? maxThreads : -1;
        int idle = timeOutMillis > 0 ? timeOutMillis : -1;
        Spark.threadPool((int)max, (int)min, (int)idle);
    }

    public static void security(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        Spark.secure((String)keystoreFile, (String)keystorePassword, (String)truststoreFile, (String)truststorePassword);
    }

    public static void spark(String verb, String path, String accept, Route route) {
        if ("get".equals(verb)) {
            if (accept != null) {
                Spark.get((String)path, (String)accept, (Route)route);
            } else {
                Spark.get((String)path, (Route)route);
            }
        } else if ("post".equals(verb)) {
            if (accept != null) {
                Spark.post((String)path, (String)accept, (Route)route);
            } else {
                Spark.post((String)path, (Route)route);
            }
        } else if ("put".equals(verb)) {
            if (accept != null) {
                Spark.put((String)path, (String)accept, (Route)route);
            } else {
                Spark.put((String)path, (Route)route);
            }
        } else if ("patch".equals(verb)) {
            if (accept != null) {
                Spark.patch((String)path, (String)accept, (Route)route);
            } else {
                Spark.patch((String)path, (Route)route);
            }
        } else if ("delete".equals(verb)) {
            if (accept != null) {
                Spark.delete((String)path, (String)accept, (Route)route);
            } else {
                Spark.delete((String)path, (Route)route);
            }
        } else if ("head".equals(verb)) {
            if (accept != null) {
                Spark.head((String)path, (String)accept, (Route)route);
            } else {
                Spark.head((String)path, (Route)route);
            }
        } else if ("trace".equals(verb)) {
            if (accept != null) {
                Spark.trace((String)path, (String)accept, (Route)route);
            } else {
                Spark.trace((String)path, (Route)route);
            }
        } else if ("connect".equals(verb)) {
            if (accept != null) {
                Spark.connect((String)path, (String)accept, (Route)route);
            } else {
                Spark.connect((String)path, (Route)route);
            }
        } else if ("options".equals(verb)) {
            if (accept != null) {
                Spark.options((String)path, (String)accept, (Route)route);
            } else {
                Spark.options((String)path, (Route)route);
            }
        }
    }
}

