/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlockEntry;
import com.microsoft.azure.storage.blob.BlockListingFilter;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.CloudPageBlob;
import com.microsoft.azure.storage.blob.PageRange;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.azure.blob.BlobBlock;
import org.apache.camel.component.azure.blob.BlobServiceConfiguration;
import org.apache.camel.component.azure.blob.BlobServiceEndpoint;
import org.apache.camel.component.azure.blob.BlobServiceOperations;
import org.apache.camel.component.azure.blob.BlobServiceRequestOptions;
import org.apache.camel.component.azure.blob.BlobServiceUtil;
import org.apache.camel.component.azure.common.ExchangeUtil;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class BlobServiceProducer
extends DefaultProducer {
    public BlobServiceProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        BlobServiceOperations operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            operation = BlobServiceOperations.listBlobs;
        } else {
            switch (operation) {
                case getBlob: {
                    this.getBlob(exchange);
                    break;
                }
                case deleteBlob: {
                    this.deleteBlob(exchange);
                    break;
                }
                case listBlobs: {
                    this.listBlobs(exchange);
                    break;
                }
                case updateBlockBlob: {
                    this.updateBlockBlob(exchange);
                    break;
                }
                case uploadBlobBlocks: {
                    this.uploadBlobBlocks(exchange);
                    break;
                }
                case commitBlobBlockList: {
                    this.commitBlobBlockList(exchange);
                    break;
                }
                case getBlobBlockList: {
                    this.getBlobBlockList(exchange);
                    break;
                }
                case createAppendBlob: {
                    this.createAppendBlob(exchange);
                    break;
                }
                case updateAppendBlob: {
                    this.updateAppendBlob(exchange);
                    break;
                }
                case createPageBlob: {
                    this.createPageBlob(exchange);
                    break;
                }
                case updatePageBlob: {
                    this.uploadPageBlob(exchange);
                    break;
                }
                case resizePageBlob: {
                    this.resizePageBlob(exchange);
                    break;
                }
                case clearPageBlob: {
                    this.clearPageBlob(exchange);
                    break;
                }
                case getPageBlobRanges: {
                    this.getPageBlobRanges(exchange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    private void listBlobs(Exchange exchange) throws Exception {
        CloudBlobContainer client = BlobServiceUtil.createBlobContainerClient(this.getConfiguration());
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        this.log.trace("Getting the blob list from the container [{}] from exchange [{}]...", (Object)this.getConfiguration().getContainerName(), (Object)exchange);
        BlobServiceConfiguration cfg = this.getConfiguration();
        EnumSet<BlobListingDetails> details = null;
        Object detailsObject = exchange.getIn().getHeader("BlobListingDetails");
        if (detailsObject instanceof EnumSet) {
            EnumSet<BlobListingDetails> theDetails;
            details = theDetails = (EnumSet<BlobListingDetails>)detailsObject;
        } else if (detailsObject instanceof BlobListingDetails) {
            details = EnumSet.of((BlobListingDetails)detailsObject);
        }
        Iterable items = client.listBlobs(cfg.getBlobPrefix(), cfg.isUseFlatListing(), details, opts.getRequestOpts(), opts.getOpContext());
        ExchangeUtil.getMessageForResponse(exchange).setBody((Object)items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBlockBlob(Exchange exchange) throws Exception {
        CloudBlockBlob client = BlobServiceUtil.createBlockBlobClient(this.getConfiguration());
        this.configureCloudBlobForWrite((CloudBlob)client);
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        InputStream inputStream = this.getInputStreamFromExchange(exchange);
        this.log.trace("Putting a block blob [{}] from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
        try {
            client.upload(inputStream, -1L, opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
        }
        finally {
            this.closeInputStreamIfNeeded(inputStream);
        }
    }

    private void uploadBlobBlocks(Exchange exchange) throws Exception {
        Object object = exchange.getIn().getMandatoryBody();
        List<BlobBlock> blobBlocks = null;
        if (object instanceof List) {
            blobBlocks = (List<BlobBlock>)object;
        } else if (object instanceof BlobBlock) {
            blobBlocks = Collections.singletonList((BlobBlock)object);
        }
        if (blobBlocks == null || blobBlocks.isEmpty()) {
            throw new IllegalArgumentException("Illegal storageBlocks payload");
        }
        CloudBlockBlob client = BlobServiceUtil.createBlockBlobClient(this.getConfiguration());
        this.configureCloudBlobForWrite((CloudBlob)client);
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        this.log.trace("Putting a blob [{}] from blocks from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
        LinkedList<BlockEntry> blockEntries = new LinkedList<BlockEntry>();
        for (BlobBlock blobBlock : blobBlocks) {
            blockEntries.add(blobBlock.getBlockEntry());
            client.uploadBlock(blobBlock.getBlockEntry().getId(), blobBlock.getBlockStream(), -1L, opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
        }
        Boolean commitBlockListLater = (Boolean)exchange.getIn().getHeader("CommitBlobBlockListLater", Boolean.class);
        if (Boolean.TRUE != commitBlockListLater) {
            client.commitBlockList(blockEntries, opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
        }
    }

    private void commitBlobBlockList(Exchange exchange) throws Exception {
        Object object = exchange.getIn().getMandatoryBody();
        List<BlockEntry> blockEntries = null;
        if (object instanceof List) {
            blockEntries = (List<BlockEntry>)object;
        } else if (object instanceof BlockEntry) {
            blockEntries = Collections.singletonList((BlockEntry)object);
        }
        if (blockEntries == null || blockEntries.isEmpty()) {
            throw new IllegalArgumentException("Illegal commit block list payload");
        }
        CloudBlockBlob client = BlobServiceUtil.createBlockBlobClient(this.getConfiguration());
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        this.log.trace("Putting a blob [{}] block list from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
        client.commitBlockList(blockEntries, opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
    }

    private void getBlob(Exchange exchange) throws Exception {
        BlobServiceUtil.getBlob(exchange, this.getConfiguration());
    }

    private void deleteBlob(Exchange exchange) throws Exception {
        switch (this.getConfiguration().getBlobType()) {
            case blockblob: {
                this.deleteBlockBlob(exchange);
                break;
            }
            case appendblob: {
                this.deleteAppendBlob(exchange);
                break;
            }
            case pageblob: {
                this.deletePageBlob(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported blob type");
            }
        }
    }

    private void getBlobBlockList(Exchange exchange) throws Exception {
        CloudBlockBlob client = BlobServiceUtil.createBlockBlobClient(this.getConfiguration());
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        this.log.trace("Getting the blob block list [{}] from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
        BlockListingFilter filter = (BlockListingFilter)exchange.getIn().getBody(BlockListingFilter.class);
        if (filter == null) {
            filter = BlockListingFilter.COMMITTED;
        }
        ArrayList blockEntries = client.downloadBlockList(filter, opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
        ExchangeUtil.getMessageForResponse(exchange).setBody((Object)blockEntries);
    }

    private void deleteBlockBlob(Exchange exchange) throws Exception {
        CloudBlockBlob client = BlobServiceUtil.createBlockBlobClient(this.getConfiguration());
        this.doDeleteBlock((CloudBlob)client, exchange);
    }

    private void createAppendBlob(Exchange exchange) throws Exception {
        CloudAppendBlob client = BlobServiceUtil.createAppendBlobClient(this.getConfiguration());
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        if (opts.getAccessCond() == null) {
            opts.setAccessCond(AccessCondition.generateIfNotExistsCondition());
        }
        this.doCreateAppendBlob(client, opts, exchange);
    }

    private void doCreateAppendBlob(CloudAppendBlob client, BlobServiceRequestOptions opts, Exchange exchange) throws Exception {
        block2: {
            this.log.trace("Creating an append blob [{}] from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
            try {
                client.createOrReplace(opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
            }
            catch (StorageException ex) {
                if (ex.getHttpStatusCode() == 409) break block2;
                throw ex;
            }
        }
        ExchangeUtil.getMessageForResponse(exchange).setHeader("AppendBlobCreated", (Object)Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAppendBlob(Exchange exchange) throws Exception {
        Boolean appendBlobCreated;
        CloudAppendBlob client = BlobServiceUtil.createAppendBlobClient(this.getConfiguration());
        this.configureCloudBlobForWrite((CloudBlob)client);
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        if (opts.getAccessCond() == null) {
            opts.setAccessCond(AccessCondition.generateIfNotExistsCondition());
        }
        if (Boolean.TRUE != (appendBlobCreated = (Boolean)exchange.getIn().getHeader("AppendBlobCreated", Boolean.class))) {
            this.doCreateAppendBlob(client, opts, exchange);
        }
        InputStream inputStream = this.getInputStreamFromExchange(exchange);
        try {
            client.appendBlock(inputStream, -1L, opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
        }
        finally {
            this.closeInputStreamIfNeeded(inputStream);
        }
    }

    private void deleteAppendBlob(Exchange exchange) throws Exception {
        CloudAppendBlob client = BlobServiceUtil.createAppendBlobClient(this.getConfiguration());
        this.doDeleteBlock((CloudBlob)client, exchange);
    }

    private void createPageBlob(Exchange exchange) throws Exception {
        CloudPageBlob client = BlobServiceUtil.createPageBlobClient(this.getConfiguration());
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        if (opts.getAccessCond() == null) {
            opts.setAccessCond(AccessCondition.generateIfNotExistsCondition());
        }
        this.doCreatePageBlob(client, opts, exchange);
    }

    private void doCreatePageBlob(CloudPageBlob client, BlobServiceRequestOptions opts, Exchange exchange) throws Exception {
        block2: {
            this.log.trace("Creating a page blob [{}] from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
            Long pageSize = this.getPageBlobSize(exchange);
            try {
                client.create(pageSize.longValue(), opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
            }
            catch (StorageException ex) {
                if (ex.getHttpStatusCode() == 409) break block2;
                throw ex;
            }
        }
        ExchangeUtil.getMessageForResponse(exchange).setHeader("PageBlobCreated", (Object)Boolean.TRUE);
    }

    private void uploadPageBlob(Exchange exchange) throws Exception {
        Boolean pageBlobCreated;
        this.log.trace("Updating a page blob [{}] from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
        CloudPageBlob client = BlobServiceUtil.createPageBlobClient(this.getConfiguration());
        this.configureCloudBlobForWrite((CloudBlob)client);
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        if (opts.getAccessCond() == null) {
            opts.setAccessCond(AccessCondition.generateIfNotExistsCondition());
        }
        if (Boolean.TRUE != (pageBlobCreated = (Boolean)exchange.getIn().getHeader("PageBlobCreated", Boolean.class))) {
            this.doCreatePageBlob(client, opts, exchange);
        }
        InputStream inputStream = this.getInputStreamFromExchange(exchange);
        this.doUpdatePageBlob(client, inputStream, opts, exchange);
    }

    private void resizePageBlob(Exchange exchange) throws Exception {
        this.log.trace("Resizing a page blob [{}] from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
        CloudPageBlob client = BlobServiceUtil.createPageBlobClient(this.getConfiguration());
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        Long pageSize = this.getPageBlobSize(exchange);
        client.resize(pageSize.longValue(), opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
    }

    private void clearPageBlob(Exchange exchange) throws Exception {
        this.log.trace("Clearing a page blob [{}] from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
        CloudPageBlob client = BlobServiceUtil.createPageBlobClient(this.getConfiguration());
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        Long blobOffset = this.getConfiguration().getBlobOffset();
        Long blobDataLength = this.getConfiguration().getDataLength();
        PageRange range = (PageRange)exchange.getIn().getHeader("PageBlobRange", PageRange.class);
        if (range != null) {
            blobOffset = range.getStartOffset();
            blobDataLength = range.getEndOffset() - range.getStartOffset();
        }
        if (blobDataLength == null) {
            blobDataLength = blobOffset == 0L ? this.getPageBlobSize(exchange) : 512L;
        }
        client.clearPages(blobOffset.longValue(), blobDataLength.longValue(), opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdatePageBlob(CloudPageBlob client, InputStream is, BlobServiceRequestOptions opts, Exchange exchange) throws Exception {
        Long blobOffset = this.getConfiguration().getBlobOffset();
        Long blobDataLength = this.getConfiguration().getDataLength();
        PageRange range = (PageRange)exchange.getIn().getHeader("PageBlobRange", PageRange.class);
        if (range != null) {
            blobOffset = range.getStartOffset();
            blobDataLength = range.getEndOffset() - range.getStartOffset();
        }
        if (blobDataLength == null) {
            blobDataLength = is.available();
        }
        try {
            client.uploadPages(is, blobOffset.longValue(), blobDataLength.longValue(), opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
        }
        finally {
            this.closeInputStreamIfNeeded(is);
        }
    }

    private void getPageBlobRanges(Exchange exchange) throws Exception {
        CloudPageBlob client = BlobServiceUtil.createPageBlobClient(this.getConfiguration());
        BlobServiceUtil.configureCloudBlobForRead((CloudBlob)client, this.getConfiguration());
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        this.log.trace("Getting the page blob ranges [{}] from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
        ArrayList ranges = client.downloadPageRanges(opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
        ExchangeUtil.getMessageForResponse(exchange).setBody((Object)ranges);
    }

    private void deletePageBlob(Exchange exchange) throws Exception {
        CloudPageBlob client = BlobServiceUtil.createPageBlobClient(this.getConfiguration());
        this.doDeleteBlock((CloudBlob)client, exchange);
    }

    private Long getPageBlobSize(Exchange exchange) {
        Long pageSize = (Long)exchange.getIn().getHeader("PageBlobSize", Long.class);
        if (pageSize == null) {
            pageSize = 512L;
        }
        return pageSize;
    }

    private void doDeleteBlock(CloudBlob client, Exchange exchange) throws Exception {
        this.log.trace("Deleting a blob [{}] from exchange [{}]...", (Object)this.getConfiguration().getBlobName(), (Object)exchange);
        client.delete();
    }

    private String getCharsetName(Exchange exchange) {
        String charset = (String)exchange.getIn().getHeader("CamelCharsetName", String.class);
        return charset == null ? "UTF-8" : charset;
    }

    private void configureCloudBlobForWrite(CloudBlob client) {
        if (this.getConfiguration().getStreamWriteSize() > 0) {
            client.setStreamWriteSizeInBytes(this.getConfiguration().getStreamWriteSize());
        }
        if (this.getConfiguration().getBlobMetadata() != null) {
            client.setMetadata(new HashMap<String, String>(this.getConfiguration().getBlobMetadata()));
        }
    }

    private BlobServiceOperations determineOperation(Exchange exchange) {
        BlobServiceOperations operation = (BlobServiceOperations)((Object)exchange.getIn().getHeader("operation", BlobServiceOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected BlobServiceConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        return "StorageBlobProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }

    public BlobServiceEndpoint getEndpoint() {
        return (BlobServiceEndpoint)super.getEndpoint();
    }

    private InputStream getInputStreamFromExchange(Exchange exchange) throws Exception {
        InputStream is;
        Object body = exchange.getIn().getBody();
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if ((is = body instanceof InputStream ? (InputStream)body : (body instanceof File ? new FileInputStream((File)body) : (body instanceof byte[] ? new ByteArrayInputStream((byte[])body) : (InputStream)exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, exchange, body)))) == null) {
            throw new IllegalArgumentException("Unsupported blob type:" + body.getClass().getName());
        }
        return is;
    }

    private void closeInputStreamIfNeeded(InputStream inputStream) throws IOException {
        if (this.getConfiguration().isCloseStreamAfterWrite()) {
            inputStream.close();
        }
    }
}

