/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.blob.BlobServiceConfiguration;
import org.apache.camel.component.azure.blob.BlobServiceConsumer;
import org.apache.camel.component.azure.blob.BlobServiceOperations;
import org.apache.camel.component.azure.blob.BlobServiceProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.19.0", scheme="azure-blob", title="Azure Storage Blob Service", syntax="azure-blob:containerOrBlobUri", label="cloud,database,nosql")
public class BlobServiceEndpoint
extends DefaultEndpoint {
    @UriPath(description="Container or Blob compact Uri")
    @Metadata(required=true)
    private String containerOrBlobUri;
    @UriParam
    private BlobServiceConfiguration configuration;

    public BlobServiceEndpoint(String uri, Component comp, BlobServiceConfiguration configuration) {
        super(uri, comp);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.log.trace("Creating a consumer");
        if (this.getConfiguration().getBlobName() == null) {
            throw new IllegalArgumentException("Blob name must be specified.");
        }
        BlobServiceConsumer consumer = new BlobServiceConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        this.log.trace("Creating a producer");
        if (this.getConfiguration().getBlobName() == null && this.getConfiguration().getOperation() != null && BlobServiceOperations.listBlobs != this.configuration.getOperation()) {
            throw new IllegalArgumentException("Blob name must be specified.");
        }
        return new BlobServiceProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public BlobServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BlobServiceConfiguration configuration) {
        this.configuration = configuration;
    }
}

