/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.springldap;

import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.springldap.LdapOperation;
import org.apache.camel.component.springldap.SpringLdapProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.springframework.ldap.core.LdapTemplate;

@UriEndpoint(firstVersion="2.11.0", scheme="spring-ldap", title="Spring LDAP", syntax="spring-ldap:templateName", producerOnly=true, label="spring,ldap")
public class SpringLdapEndpoint
extends DefaultEndpoint {
    private static final String OBJECT_SCOPE_NAME = "object";
    private static final String ONELEVEL_SCOPE_NAME = "onelevel";
    private static final String SUBTREE_SCOPE_NAME = "subtree";
    private LdapTemplate ldapTemplate;
    @UriPath
    @Metadata(required=true)
    private String templateName;
    @UriParam
    @Metadata(required=true)
    private LdapOperation operation;
    @UriParam(defaultValue="subtree", enums="object,onelevel,subtree")
    private String scope = "subtree";

    public SpringLdapEndpoint(String templateName, LdapTemplate ldapTemplate) {
        this.templateName = templateName;
        this.ldapTemplate = ldapTemplate;
    }

    public Producer createProducer() throws Exception {
        return new SpringLdapProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("spring-ldap endpoint supports producer enrpoint only.");
    }

    public boolean isSingleton() {
        return false;
    }

    public String createEndpointUri() {
        return "spring-ldap://" + this.templateName + "?operation=" + this.operation.name() + "&scope=" + this.getScope();
    }

    public LdapTemplate getLdapTemplate() {
        return this.ldapTemplate;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public LdapOperation getOperation() {
        return this.operation;
    }

    public void setOperation(LdapOperation operation) {
        this.operation = operation;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int scopeValue() {
        if (this.scope.equals(OBJECT_SCOPE_NAME)) {
            return 0;
        }
        if (this.scope.equals(ONELEVEL_SCOPE_NAME)) {
            return 1;
        }
        return 2;
    }
}

