/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.NamedNode;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.StatefulService;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultRouteContext;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class RouteReifier
extends ProcessorReifier<RouteDefinition> {
    public RouteReifier(ProcessorDefinition<?> definition) {
        super((RouteDefinition)definition);
    }

    public static RouteDefinition adviceWith(RouteDefinition definition, CamelContext camelContext, RouteBuilder builder) throws Exception {
        return RouteReifier.adviceWith(definition, (ModelCamelContext)camelContext.adapt(ModelCamelContext.class), builder);
    }

    public static RouteDefinition adviceWith(RouteDefinition definition, ModelCamelContext camelContext, RouteBuilder builder) throws Exception {
        return new RouteReifier(definition).adviceWith(camelContext, builder);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        throw new UnsupportedOperationException("Not implemented for RouteDefinition");
    }

    public List<RouteContext> addRoutes(ModelCamelContext camelContext, Collection<Route> routes) throws Exception {
        RouteContext routeContext;
        ArrayList<RouteContext> answer = new ArrayList<RouteContext>();
        ErrorHandlerFactory handler = camelContext.getErrorHandlerFactory();
        if (handler != null) {
            ((RouteDefinition)this.definition).setErrorHandlerBuilderIfNull(handler);
        }
        try {
            routeContext = this.addRoutes(camelContext, routes, ((RouteDefinition)this.definition).getInput());
        }
        catch (FailedToCreateRouteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), (Throwable)e);
        }
        answer.add(routeContext);
        return answer;
    }

    public Endpoint resolveEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        ObjectHelper.notNull((Object)camelContext, (String)"CamelContext");
        return CamelContextHelper.getMandatoryEndpoint((CamelContext)camelContext, (String)uri);
    }

    public RouteDefinition adviceWith(CamelContext camelContext, RouteBuilder builder) throws Exception {
        return this.adviceWith((ModelCamelContext)camelContext, builder);
    }

    public RouteDefinition adviceWith(ModelCamelContext camelContext, RouteBuilder builder) throws Exception {
        StatefulService service;
        ObjectHelper.notNull((Object)camelContext, (String)"CamelContext");
        ObjectHelper.notNull((Object)builder, (String)"RouteBuilder");
        this.log.debug("AdviceWith route before: {}", (Object)this);
        if (builder instanceof AdviceWithRouteBuilder) {
            ((AdviceWithRouteBuilder)builder).setOriginalRoute((RouteDefinition)this.definition);
        }
        RoutesDefinition routes = builder.configureRoutes(camelContext);
        this.log.debug("AdviceWith routes: {}", (Object)routes);
        if (!builder.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("You can only advice from a RouteBuilder which has no existing routes. Remove all routes from the route builder.");
        }
        if (builder.getRouteCollection().getErrorHandlerFactory() != null && camelContext.getErrorHandlerFactory() != builder.getRouteCollection().getErrorHandlerFactory()) {
            throw new IllegalArgumentException("You can not advice with error handlers. Remove the error handlers from the route builder.");
        }
        String beforeAsXml = ModelHelper.dumpModelAsXml(camelContext, this.definition);
        camelContext.removeRouteDefinition((RouteDefinition)this.definition);
        if (builder instanceof AdviceWithRouteBuilder) {
            List<AdviceWithTask> tasks = ((AdviceWithRouteBuilder)builder).getAdviceWithTasks();
            for (AdviceWithTask task : tasks) {
                task.task();
            }
        }
        RouteDefinition merged = routes.route((RouteDefinition)this.definition);
        camelContext.getRouteDefinitions().add(0, merged);
        this.log.info("AdviceWith route after: {}", (Object)merged);
        String afterAsXml = ModelHelper.dumpModelAsXml(camelContext, merged);
        this.log.info("Adviced route before/after as XML:\n{}\n{}", (Object)beforeAsXml, (Object)afterAsXml);
        if (camelContext instanceof StatefulService && (service = (StatefulService)camelContext).isStarted()) {
            ((ModelCamelContext)camelContext.adapt(ModelCamelContext.class)).addRouteDefinition(merged);
        }
        return merged;
    }

    protected RouteContext addRoutes(CamelContext camelContext, Collection<Route> routes, FromDefinition fromType) throws Exception {
        Boolean isAutoStartup;
        RoutePolicy policy;
        Object delayer;
        Boolean isHandleFault;
        Boolean isStreamCache;
        Boolean isLogMask;
        Boolean isMessageHistory;
        Boolean isTrace;
        DefaultRouteContext routeContext = new DefaultRouteContext(camelContext, (RouteDefinition)this.definition, fromType, routes);
        if (((RouteDefinition)this.definition).getTrace() != null && (isTrace = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getTrace())) != null) {
            routeContext.setTracing(isTrace);
            if (isTrace.booleanValue()) {
                this.log.debug("Tracing is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getMessageHistory() != null && (isMessageHistory = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getMessageHistory())) != null) {
            routeContext.setMessageHistory(isMessageHistory);
            if (isMessageHistory.booleanValue()) {
                this.log.debug("Message history is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getLogMask() != null && (isLogMask = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getLogMask())) != null) {
            routeContext.setLogMask(isLogMask);
            if (isLogMask.booleanValue()) {
                this.log.debug("Security mask for Logging is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getStreamCache() != null && (isStreamCache = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getStreamCache())) != null) {
            routeContext.setStreamCaching(isStreamCache);
            if (isStreamCache.booleanValue()) {
                this.log.debug("StreamCaching is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getHandleFault() != null && (isHandleFault = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getHandleFault())) != null) {
            routeContext.setHandleFault(isHandleFault);
            if (isHandleFault.booleanValue()) {
                this.log.debug("HandleFault is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
                if (HandleFault.getHandleFault(camelContext) == null) {
                    ((RouteDefinition)this.definition).addInterceptStrategy(new HandleFault());
                }
            }
        }
        if (((RouteDefinition)this.definition).getDelayer() != null && (delayer = CamelContextHelper.parseLong((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getDelayer())) != null) {
            routeContext.setDelayer((Long)delayer);
            if ((Long)delayer > 0L) {
                this.log.debug("Delayer is enabled with: {} ms. on route: {}", delayer, (Object)((RouteDefinition)this.definition).getId());
            } else {
                this.log.debug("Delayer is disabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getRoutePolicies() != null && !((RouteDefinition)this.definition).getRoutePolicies().isEmpty()) {
            for (RoutePolicy policy2 : ((RouteDefinition)this.definition).getRoutePolicies()) {
                this.log.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy2, (Object)((RouteDefinition)this.definition).getId());
                routeContext.getRoutePolicyList().add(policy2);
            }
        }
        if (((RouteDefinition)this.definition).getRoutePolicyRef() != null) {
            StringTokenizer policyTokens = new StringTokenizer(((RouteDefinition)this.definition).getRoutePolicyRef(), ",");
            while (policyTokens.hasMoreTokens()) {
                String ref = policyTokens.nextToken().trim();
                policy = (RoutePolicy)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)ref, RoutePolicy.class);
                this.log.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy, (Object)((RouteDefinition)this.definition).getId());
                routeContext.getRoutePolicyList().add(policy);
            }
        }
        if (camelContext.getRoutePolicyFactories() != null) {
            for (Object factory : camelContext.getRoutePolicyFactories()) {
                policy = factory.createRoutePolicy(camelContext, ((RouteDefinition)this.definition).getId(), (NamedNode)this.definition);
                if (policy == null) continue;
                this.log.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy, (Object)((RouteDefinition)this.definition).getId());
                routeContext.getRoutePolicyList().add(policy);
            }
        }
        if ((isAutoStartup = CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)((RouteDefinition)this.definition).getAutoStartup())) != null) {
            this.log.debug("Using AutoStartup {} on route: {}", (Object)isAutoStartup, (Object)((RouteDefinition)this.definition).getId());
            routeContext.setAutoStartup(isAutoStartup);
        }
        if (((RouteDefinition)this.definition).getShutdownRoute() != null) {
            this.log.debug("Using ShutdownRoute {} on route: {}", (Object)((RouteDefinition)this.definition).getShutdownRoute(), (Object)((RouteDefinition)this.definition).getId());
            routeContext.setShutdownRoute(((RouteDefinition)this.definition).getShutdownRoute());
        }
        if (((RouteDefinition)this.definition).getShutdownRunningTask() != null) {
            this.log.debug("Using ShutdownRunningTask {} on route: {}", (Object)((RouteDefinition)this.definition).getShutdownRunningTask(), (Object)((RouteDefinition)this.definition).getId());
            routeContext.setShutdownRunningTask(((RouteDefinition)this.definition).getShutdownRunningTask());
        }
        routeContext.setInterceptStrategies(((RouteDefinition)this.definition).getInterceptStrategies());
        routeContext.getEndpoint();
        for (LifecycleStrategy strategy : camelContext.getLifecycleStrategies()) {
            strategy.onRouteContextCreate((RouteContext)routeContext);
        }
        if (!ProcessorDefinitionHelper.hasOutputs(((RouteDefinition)this.definition).getOutputs(), true)) {
            RouteDefinition route = (RouteDefinition)routeContext.getRoute();
            String at = fromType.toString();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Route " + route.getId() + " has no output processors. You need to add outputs to the route such as to(\"log:foo\").");
            throw new FailedToCreateRouteException(route.getId(), route.toString(), at, (Throwable)illegalArgumentException);
        }
        ArrayList list = new ArrayList(((RouteDefinition)this.definition).getOutputs());
        for (ProcessorDefinition processorDefinition : list) {
            try {
                ProcessorReifier.reifier(processorDefinition).addRoutes(routeContext, routes);
            }
            catch (Exception e) {
                RouteDefinition route = (RouteDefinition)routeContext.getRoute();
                throw new FailedToCreateRouteException(route.getId(), route.toString(), processorDefinition.toString(), (Throwable)e);
            }
        }
        routeContext.commit();
        return routeContext;
    }
}

