/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.FatalFallbackErrorHandler;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

class OnExceptionReifier
extends ProcessorReifier<OnExceptionDefinition> {
    OnExceptionReifier(ProcessorDefinition<?> definition) {
        super((OnExceptionDefinition)definition);
    }

    @Override
    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        Processor child;
        if (((OnExceptionDefinition)this.definition).getRouteScoped() == null) {
            ((OnExceptionDefinition)this.definition).setRouteScoped(((OnExceptionDefinition)this.definition).getParent() != null);
        }
        this.setHandledFromExpressionType(routeContext);
        this.setContinuedFromExpressionType(routeContext);
        this.setRetryWhileFromExpressionType(routeContext);
        this.setOnRedeliveryFromRedeliveryRef(routeContext);
        this.setOnExceptionOccurredFromOnExceptionOccurredRef(routeContext);
        if (((OnExceptionDefinition)this.definition).getExceptions() != null && !((OnExceptionDefinition)this.definition).getExceptions().isEmpty()) {
            ((OnExceptionDefinition)this.definition).setExceptionClasses(this.createExceptionClasses(routeContext.getCamelContext().getClassResolver()));
        }
        ((OnExceptionDefinition)this.definition).validateConfiguration();
        if (((OnExceptionDefinition)this.definition).getUseOriginalMessagePolicy() != null && ((OnExceptionDefinition)this.definition).getUseOriginalMessagePolicy().booleanValue()) {
            routeContext.setAllowUseOriginalMessage(Boolean.valueOf(true));
        }
        if ((child = this.createOutputsProcessor(routeContext)) != null) {
            FatalFallbackErrorHandler errorHandler = new FatalFallbackErrorHandler(child);
            String id = routeContext.getRoute().getId();
            ((OnExceptionDefinition)this.definition).setErrorHandler(id, errorHandler);
        }
        ErrorHandlerBuilder builder = (ErrorHandlerBuilder)((RouteDefinition)routeContext.getRoute()).getErrorHandlerBuilder();
        builder.addErrorHandlers(routeContext, (OnExceptionDefinition)this.definition);
    }

    public CatchProcessor createProcessor(RouteContext routeContext) throws Exception {
        if (((OnExceptionDefinition)this.definition).getExceptions() != null && !((OnExceptionDefinition)this.definition).getExceptions().isEmpty()) {
            ((OnExceptionDefinition)this.definition).setExceptionClasses(this.createExceptionClasses(routeContext.getCamelContext().getClassResolver()));
        }
        if (((OnExceptionDefinition)this.definition).getUseOriginalMessagePolicy() != null && ((OnExceptionDefinition)this.definition).getUseOriginalMessagePolicy().booleanValue()) {
            routeContext.setAllowUseOriginalMessage(Boolean.valueOf(true));
        }
        ((OnExceptionDefinition)this.definition).validateConfiguration();
        Processor childProcessor = this.createChildProcessor(routeContext, false);
        Predicate when = null;
        if (((OnExceptionDefinition)this.definition).getOnWhen() != null) {
            when = ((OnExceptionDefinition)this.definition).getOnWhen().getExpression().createPredicate(routeContext);
        }
        Predicate handle = null;
        if (((OnExceptionDefinition)this.definition).getHandled() != null) {
            handle = ((OnExceptionDefinition)this.definition).getHandled().createPredicate(routeContext);
        }
        return new CatchProcessor(((OnExceptionDefinition)this.definition).getExceptionClasses(), childProcessor, when, handle);
    }

    protected List<Class<? extends Throwable>> createExceptionClasses(ClassResolver resolver) throws ClassNotFoundException {
        List<String> list = ((OnExceptionDefinition)this.definition).getExceptions();
        ArrayList<Class<? extends Throwable>> answer = new ArrayList<Class<? extends Throwable>>(list.size());
        for (String name : list) {
            Class type = resolver.resolveMandatoryClass(name, Throwable.class);
            answer.add(type);
        }
        return answer;
    }

    private void setHandledFromExpressionType(RouteContext routeContext) {
        if (((OnExceptionDefinition)this.definition).getHandled() != null && ((OnExceptionDefinition)this.definition).getHandledPolicy() == null && routeContext != null) {
            ((OnExceptionDefinition)this.definition).handled(((OnExceptionDefinition)this.definition).getHandled().createPredicate(routeContext));
        }
    }

    private void setContinuedFromExpressionType(RouteContext routeContext) {
        if (((OnExceptionDefinition)this.definition).getContinued() != null && ((OnExceptionDefinition)this.definition).getContinuedPolicy() == null && routeContext != null) {
            ((OnExceptionDefinition)this.definition).continued(((OnExceptionDefinition)this.definition).getContinued().createPredicate(routeContext));
        }
    }

    private void setRetryWhileFromExpressionType(RouteContext routeContext) {
        if (((OnExceptionDefinition)this.definition).getRetryWhile() != null && ((OnExceptionDefinition)this.definition).getRetryWhilePolicy() == null && routeContext != null) {
            ((OnExceptionDefinition)this.definition).retryWhile(((OnExceptionDefinition)this.definition).getRetryWhile().createPredicate(routeContext));
        }
    }

    private void setOnRedeliveryFromRedeliveryRef(RouteContext routeContext) {
        if (ObjectHelper.isNotEmpty((Object)((OnExceptionDefinition)this.definition).getOnRedeliveryRef())) {
            Processor onRedelivery = (Processor)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)((OnExceptionDefinition)this.definition).getOnRedeliveryRef(), Processor.class);
            ((OnExceptionDefinition)this.definition).setOnRedelivery(onRedelivery);
        }
    }

    private void setOnExceptionOccurredFromOnExceptionOccurredRef(RouteContext routeContext) {
        if (ObjectHelper.isNotEmpty((Object)((OnExceptionDefinition)this.definition).getOnExceptionOccurredRef())) {
            Processor onExceptionOccurred = (Processor)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)((OnExceptionDefinition)this.definition).getOnExceptionOccurredRef(), Processor.class);
            ((OnExceptionDefinition)this.definition).setOnExceptionOccurred(onExceptionOccurred);
        }
    }
}

