/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Processor;
import org.apache.camel.model.ClaimCheckDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.ClaimCheckProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

class ClaimCheckReifier
extends ProcessorReifier<ClaimCheckDefinition> {
    ClaimCheckReifier(ProcessorDefinition<?> definition) {
        super((ProcessorDefinition)ClaimCheckDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notNull((Object)((Object)((ClaimCheckDefinition)this.definition).getOperation()), (String)"operation", (Object)this);
        ClaimCheckProcessor claim = new ClaimCheckProcessor();
        claim.setOperation(((ClaimCheckDefinition)this.definition).getOperation().name());
        claim.setKey(((ClaimCheckDefinition)this.definition).getKey());
        claim.setFilter(((ClaimCheckDefinition)this.definition).getFilter());
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        if (strategy != null) {
            claim.setAggregationStrategy(strategy);
        }
        if (((ClaimCheckDefinition)this.definition).getFilter() != null && strategy != null) {
            throw new IllegalArgumentException("Cannot use both filter and custom aggregation strategy on ClaimCheck EIP");
        }
        if (((ClaimCheckDefinition)this.definition).getFilter() != null) {
            Iterable it = org.apache.camel.support.ObjectHelper.createIterable((String)((ClaimCheckDefinition)this.definition).getFilter(), (String)",");
            boolean includeBody = false;
            boolean excludeBody = false;
            for (Object o : it) {
                String pattern = o.toString();
                if ("body".equals(pattern) || "+body".equals(pattern)) {
                    includeBody = true;
                    continue;
                }
                if (!"-body".equals(pattern)) continue;
                excludeBody = true;
            }
            if (includeBody && excludeBody) {
                throw new IllegalArgumentException("Cannot have both include and exclude body at the same time in the filter: " + ((ClaimCheckDefinition)this.definition).getFilter());
            }
            boolean includeHeaders = false;
            boolean excludeHeaders = false;
            for (Object o : it) {
                String pattern = o.toString();
                if ("headers".equals(pattern) || "+headers".equals(pattern)) {
                    includeHeaders = true;
                    continue;
                }
                if (!"-headers".equals(pattern)) continue;
                excludeHeaders = true;
            }
            if (includeHeaders && excludeHeaders) {
                throw new IllegalArgumentException("Cannot have both include and exclude headers at the same time in the filter: " + ((ClaimCheckDefinition)this.definition).getFilter());
            }
            boolean includeHeader = false;
            boolean excludeHeader = false;
            for (Object o : it) {
                String pattern = o.toString();
                if (pattern.startsWith("header:") || pattern.startsWith("+header:")) {
                    includeHeader = true;
                    continue;
                }
                if (!pattern.startsWith("-header:")) continue;
                excludeHeader = true;
            }
            if (includeHeader && excludeHeader) {
                throw new IllegalArgumentException("Cannot have both include and exclude header at the same time in the filter: " + ((ClaimCheckDefinition)this.definition).getFilter());
            }
        }
        return claim;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = ((ClaimCheckDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((ClaimCheckDefinition)this.definition).getAggregationStrategyRef() != null) {
            Object aggStrategy = routeContext.lookup(((ClaimCheckDefinition)this.definition).getAggregationStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                strategy = new AggregationStrategyBeanAdapter(aggStrategy, ((ClaimCheckDefinition)this.definition).getAggregationStrategyMethodName());
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((ClaimCheckDefinition)this.definition).getAggregationStrategyRef());
            }
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(routeContext.getCamelContext());
        }
        return strategy;
    }
}

