/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import org.apache.camel.Processor;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;

class ChoiceReifier
extends ProcessorReifier<ChoiceDefinition> {
    ChoiceReifier(ProcessorDefinition<?> definition) {
        super((ProcessorDefinition)ChoiceDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ArrayList<FilterProcessor> filters = new ArrayList<FilterProcessor>();
        for (WhenDefinition whenClause : ((ChoiceDefinition)this.definition).getWhenClauses()) {
            WhenDefinition exp = whenClause;
            ExpressionDefinition expressionDefinition = exp.getExpression();
            if (expressionDefinition != null) {
                ProcessorDefinitionHelper.resolvePropertyPlaceholders(routeContext.getCamelContext(), expressionDefinition);
                ProcessorDefinitionHelper.resolveKnownConstantFields(expressionDefinition);
            }
            FilterProcessor filter = (FilterProcessor)this.createProcessor(routeContext, whenClause);
            filters.add(filter);
        }
        Processor otherwiseProcessor = null;
        if (((ChoiceDefinition)this.definition).getOtherwise() != null) {
            otherwiseProcessor = this.createProcessor(routeContext, ((ChoiceDefinition)this.definition).getOtherwise());
        }
        return new ChoiceProcessor(filters, otherwiseProcessor);
    }
}

