/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ConstantStaticTypeBeanHolder;
import org.apache.camel.component.bean.ConstantTypeBeanHolder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

class BeanReifier
extends ProcessorReifier<BeanDefinition> {
    BeanReifier(ProcessorDefinition<?> definition) {
        super((ProcessorDefinition)BeanDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        BeanProcessor answer;
        BeanHolder beanHolder;
        Class clazz;
        Object bean = ((BeanDefinition)this.definition).getBean();
        String ref = ((BeanDefinition)this.definition).getRef();
        String method = ((BeanDefinition)this.definition).getMethod();
        String beanType = ((BeanDefinition)this.definition).getBeanType();
        Class<?> beanClass = ((BeanDefinition)this.definition).getBeanClass();
        Class clazz2 = clazz = bean != null ? bean.getClass() : null;
        if (ObjectHelper.isNotEmpty((Object)ref)) {
            if (this.isCacheBean()) {
                beanHolder = new RegistryBean(routeContext.getCamelContext(), ref).createCacheHolder();
                bean = beanHolder.getBean();
            } else {
                beanHolder = new RegistryBean(routeContext.getCamelContext(), ref);
            }
            answer = new BeanProcessor(beanHolder);
        } else {
            if (bean == null) {
                if (beanType == null && beanClass == null) {
                    throw new IllegalArgumentException("bean, ref or beanType must be provided");
                }
                if (beanType != null) {
                    try {
                        clazz = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(beanType);
                    }
                    catch (ClassNotFoundException e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                } else {
                    clazz = beanClass;
                }
                if (this.isCacheBean() && routeContext.getCamelContext().getInjector().supportsAutoWiring()) {
                    try {
                        this.log.debug("Attempting to create new bean instance from class: {} via auto-wiring enabled", (Object)clazz);
                        bean = CamelContextHelper.newInstance((CamelContext)routeContext.getCamelContext(), (Class)clazz);
                    }
                    catch (Throwable e) {
                        this.log.debug("Error creating new bean instance from class: " + clazz + ". This exception is ignored", e);
                    }
                }
                if (bean == null && this.isCacheBean() && ObjectHelper.hasDefaultPublicNoArgConstructor((Class)clazz)) {
                    this.log.debug("Class has default no-arg constructor so creating a new bean instance: {}", (Object)clazz);
                    bean = CamelContextHelper.newInstance((CamelContext)routeContext.getCamelContext(), (Class)clazz);
                    ObjectHelper.notNull((Object)bean, (String)"bean", (Object)this);
                }
            }
            if (bean instanceof String) {
                throw new IllegalArgumentException("The bean instance is a java.lang.String type: " + bean + ". We suppose you want to refer to a bean instance by its id instead. Please use ref.");
            }
            beanHolder = bean != null ? new ConstantBeanHolder(bean, routeContext.getCamelContext()) : (this.isCacheBean() && ObjectHelper.hasDefaultPublicNoArgConstructor(clazz) ? new ConstantTypeBeanHolder(clazz, routeContext.getCamelContext()).createCacheHolder() : (ObjectHelper.hasDefaultPublicNoArgConstructor(clazz) ? new ConstantTypeBeanHolder(clazz, routeContext.getCamelContext()) : new ConstantStaticTypeBeanHolder(clazz, routeContext.getCamelContext())));
            answer = new BeanProcessor(beanHolder);
        }
        if (method != null) {
            answer.setMethod(method);
            if (this.isCacheBean()) {
                BeanInfo beanInfo = beanHolder.getBeanInfo();
                if (bean != null) {
                    if (!beanInfo.hasMethod(method)) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new MethodNotFoundException(null, bean, method)));
                    }
                } else if (clazz != null && !beanInfo.hasStaticMethod(method)) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new MethodNotFoundException(null, clazz, method, true)));
                }
            }
        }
        return answer;
    }

    private boolean isCacheBean() {
        return ((BeanDefinition)this.definition).getCache() == null || ((BeanDefinition)this.definition).getCache() != false;
    }
}

