/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.saga;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.SagaCompletionMode;
import org.apache.camel.processor.saga.SagaProcessor;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;

public class SupportsSagaProcessor
extends SagaProcessor {
    public SupportsSagaProcessor(CamelContext camelContext, Processor childProcessor, CamelSagaService sagaService, SagaCompletionMode completionMode, CamelSagaStep step) {
        super(camelContext, childProcessor, sagaService, completionMode, step);
        if (completionMode != null && completionMode != SagaCompletionMode.defaultCompletionMode()) {
            throw new IllegalArgumentException("CompletionMode cannot be specified when propagation is SUPPORTS");
        }
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.getCurrentSagaCoordinator(exchange).whenComplete((coordinator, ex) -> this.ifNotException((Throwable)ex, exchange, callback, () -> {
            if (coordinator != null) {
                coordinator.beginStep(exchange, this.step).whenComplete((done, ex2) -> this.ifNotException((Throwable)ex2, exchange, callback, () -> super.process(exchange, doneSync -> callback.done(false))));
            } else {
                super.process(exchange, doneSync -> callback.done(false));
            }
        }));
        return false;
    }
}

