/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.support.processor.DelegateAsyncProcessor;

public class HandleFaultInterceptor
extends DelegateAsyncProcessor {
    public HandleFaultInterceptor() {
    }

    public HandleFaultInterceptor(Processor processor) {
        super(processor);
    }

    public String toString() {
        return "HandleFaultInterceptor[" + this.processor + "]";
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        return this.processor.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                try {
                    HandleFaultInterceptor.this.handleFault(exchange);
                }
                finally {
                    callback.done(doneSync);
                }
            }
        });
    }

    protected void handleFault(Exchange exchange) {
        Object faultBody;
        Message msg;
        Message message = msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        if (msg.isFault() && (faultBody = msg.getBody()) != null && exchange.getException() == null) {
            if (exchange.hasOut()) {
                exchange.setOut(null);
            } else {
                exchange.setIn(null);
            }
            if (faultBody instanceof Throwable) {
                exchange.setException((Throwable)faultBody);
            } else {
                String data = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, faultBody);
                exchange.setException((Throwable)new CamelException(data));
            }
        }
    }
}

