/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Processor;
import org.apache.camel.model.ModelChannel;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.CamelInternalProcessorAdvice;
import org.apache.camel.processor.RedeliveryErrorHandler;
import org.apache.camel.processor.WrapProcessor;
import org.apache.camel.processor.interceptor.BacklogDebugger;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.service.ServiceHelper;

public class DefaultChannel
extends CamelInternalProcessor
implements ModelChannel {
    private final List<InterceptStrategy> interceptors = new ArrayList<InterceptStrategy>();
    private Processor errorHandler;
    private Processor nextProcessor;
    private Processor output;
    private ProcessorDefinition<?> definition;
    private ProcessorDefinition<?> childDefinition;
    private ManagementInterceptStrategy.InstrumentationProcessor<?> instrumentationProcessor;
    private CamelContext camelContext;
    private RouteContext routeContext;

    public void setNextProcessor(Processor next) {
        this.nextProcessor = next;
    }

    public Processor getOutput() {
        return this.errorHandler != null ? this.errorHandler : this.output;
    }

    public boolean hasNext() {
        return this.nextProcessor != null;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.nextProcessor);
        return answer;
    }

    public void setOutput(Processor output) {
        this.output = output;
    }

    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    public boolean hasInterceptorStrategy(Class<?> type) {
        for (InterceptStrategy strategy : this.interceptors) {
            if (!type.isInstance(strategy)) continue;
            return true;
        }
        return false;
    }

    public void setErrorHandler(Processor errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    public void addInterceptStrategy(InterceptStrategy strategy) {
        this.interceptors.add(strategy);
    }

    public void addInterceptStrategies(List<InterceptStrategy> strategies) {
        this.interceptors.addAll(strategies);
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptors;
    }

    @Override
    public ProcessorDefinition<?> getProcessorDefinition() {
        return this.definition;
    }

    @Override
    public void setChildDefinition(ProcessorDefinition<?> childDefinition) {
        this.childDefinition = childDefinition;
    }

    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    protected void doStart() throws Exception {
        this.setProcessor(this.getOutput());
        ServiceHelper.startService((Object[])new Object[]{this.errorHandler, this.output});
    }

    protected void doStop() throws Exception {
        if (!this.isContextScoped()) {
            ServiceHelper.stopService((Object[])new Object[]{this.output, this.errorHandler});
        }
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.output, this.errorHandler});
    }

    private boolean isContextScoped() {
        if (this.definition instanceof OnExceptionDefinition) {
            return !((OnExceptionDefinition)this.definition).isRouteScoped();
        }
        if (this.definition instanceof OnCompletionDefinition) {
            return !((OnCompletionDefinition)this.definition).isRouteScoped();
        }
        return false;
    }

    @Override
    public void initChannel(ProcessorDefinition<?> outputDefinition, RouteContext routeContext) throws Exception {
        this.routeContext = routeContext;
        this.definition = outputDefinition;
        this.camelContext = routeContext.getCamelContext();
        Processor target = this.nextProcessor;
        if (target instanceof CamelContextAware) {
            ((CamelContextAware)target).setCamelContext(this.camelContext);
        }
        ProcessorDefinition<?> targetOutputDef = this.childDefinition != null ? this.childDefinition : outputDefinition;
        this.log.debug("Initialize channel for target: '{}'", targetOutputDef);
        if (this.childDefinition != null && outputDefinition != this.childDefinition) {
            this.childDefinition.setParent(outputDefinition);
        }
        RouteDefinitionHelper.forceAssignIds(routeContext.getCamelContext(), this.definition);
        ManagementInterceptStrategy managed = routeContext.getManagementInterceptStrategy();
        if (managed != null) {
            this.instrumentationProcessor = managed.createProcessor(targetOutputDef, target);
        }
        BacklogTracer tracer = this.getOrCreateBacklogTracer();
        this.camelContext.setExtension(BacklogTracer.class, (Object)tracer);
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(this.definition);
        boolean first = false;
        if (route != null && !route.getOutputs().isEmpty()) {
            first = route.getOutputs().get(0) == this.definition;
        }
        this.addAdvice(new CamelInternalProcessor.BacklogTracerAdvice(tracer, targetOutputDef, route, first));
        BacklogDebugger debugger = this.getOrCreateBacklogDebugger();
        this.camelContext.addService((Object)debugger);
        this.addAdvice(new CamelInternalProcessor.BacklogDebuggerAdvice(debugger, target, targetOutputDef));
        if (routeContext.isMessageHistory().booleanValue()) {
            MessageHistoryFactory factory = this.camelContext.getMessageHistoryFactory();
            this.addAdvice(new CamelInternalProcessor.MessageHistoryAdvice(factory, targetOutputDef));
        }
        this.interceptors.sort((Comparator<InterceptStrategy>)OrderedComparator.get());
        Collections.reverse(this.interceptors);
        for (InterceptStrategy strategy : this.interceptors) {
            Processor next = target == this.nextProcessor ? null : this.nextProcessor;
            Object wrapped = strategy.wrapProcessorInInterceptors(routeContext.getCamelContext(), targetOutputDef, target, next);
            if (!(wrapped instanceof AsyncProcessor)) {
                this.log.warn("Interceptor: " + strategy + " at: " + outputDefinition + " does not return an AsyncProcessor instance. This causes the asynchronous routing engine to not work as optimal as possible. See more details at the InterceptStrategy javadoc. Camel will use a bridge to adapt the interceptor to the asynchronous routing engine, but its not the most optimal solution. Please consider changing your interceptor to comply.");
            }
            if (!(wrapped instanceof WrapProcessor)) {
                wrapped = new WrapProcessor((Processor)wrapped, target);
            }
            target = wrapped;
        }
        if (routeContext.isStreamCaching().booleanValue()) {
            this.addAdvice(new CamelInternalProcessor.StreamCachingAdvice(this.camelContext.getStreamCachingStrategy()));
        }
        if (routeContext.getDelayer() != null && routeContext.getDelayer() > 0L) {
            this.addAdvice(new CamelInternalProcessor.DelayerAdvice(routeContext.getDelayer()));
        }
        this.output = target;
    }

    @Override
    public void postInitChannel(ProcessorDefinition<?> outputDefinition, RouteContext routeContext) throws Exception {
        if (this.instrumentationProcessor != null) {
            boolean redeliveryPossible = false;
            if (this.errorHandler instanceof RedeliveryErrorHandler && (redeliveryPossible = ((RedeliveryErrorHandler)this.errorHandler).determineIfRedeliveryIsEnabled())) {
                Processor currentOutput = ((RedeliveryErrorHandler)this.errorHandler).getOutput();
                this.instrumentationProcessor.setProcessor(currentOutput);
                ((RedeliveryErrorHandler)this.errorHandler).changeOutput((Processor)this.instrumentationProcessor);
            }
            if (!redeliveryPossible) {
                this.addAdvice(CamelInternalProcessorAdvice.wrap(this.instrumentationProcessor));
            }
        }
    }

    private BacklogTracer getOrCreateBacklogTracer() {
        Map map;
        BacklogTracer tracer = null;
        if (this.camelContext.getRegistry() != null && (map = this.camelContext.getRegistry().findByTypeWithName(BacklogTracer.class)).size() == 1) {
            tracer = (BacklogTracer)((Object)map.values().iterator().next());
        }
        if (tracer == null) {
            tracer = (BacklogTracer)((Object)this.camelContext.getExtension(BacklogTracer.class));
        }
        if (tracer == null) {
            tracer = BacklogTracer.createTracer(this.camelContext);
        }
        return tracer;
    }

    private BacklogDebugger getOrCreateBacklogDebugger() {
        Map map;
        BacklogDebugger debugger = null;
        if (this.camelContext.getRegistry() != null && (map = this.camelContext.getRegistry().findByTypeWithName(BacklogDebugger.class)).size() == 1) {
            debugger = (BacklogDebugger)((Object)map.values().iterator().next());
        }
        if (debugger == null) {
            debugger = (BacklogDebugger)((Object)this.camelContext.hasService(BacklogDebugger.class));
        }
        if (debugger == null) {
            debugger = BacklogDebugger.createDebugger(this.camelContext);
        }
        return debugger;
    }

    @Override
    public String toString() {
        return "Channel[" + this.nextProcessor + "]";
    }
}

