/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.ParameterInfo;

public class AggregationStrategyMethodInfo {
    private final Method method;
    private final List<ParameterInfo> oldParameters;
    private final List<ParameterInfo> newParameters;

    public AggregationStrategyMethodInfo(Method method, List<ParameterInfo> oldParameters, List<ParameterInfo> newParameters) {
        this.method = method;
        this.oldParameters = oldParameters;
        this.newParameters = newParameters;
    }

    public Object invoke(Object pojo, Exchange oldExchange, Exchange newExchange) throws Exception {
        Object value;
        ArrayList<Object> list = new ArrayList<Object>(this.oldParameters.size() + this.newParameters.size());
        for (ParameterInfo info : this.oldParameters) {
            if (oldExchange != null) {
                value = info.getExpression().evaluate(oldExchange, info.getType());
                list.add(value);
                continue;
            }
            list.add(null);
        }
        for (ParameterInfo info : this.newParameters) {
            if (newExchange != null) {
                value = info.getExpression().evaluate(newExchange, info.getType());
                list.add(value);
                continue;
            }
            list.add(null);
        }
        Object[] args = list.toArray();
        return this.method.invoke(pojo, args);
    }
}

