/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;

public final class UnitOfWorkProducer
extends DefaultAsyncProducer {
    private final Producer producer;
    private final AsyncProcessor processor;

    public UnitOfWorkProducer(Producer producer) {
        super(producer.getEndpoint());
        this.producer = producer;
        CamelInternalProcessor internal = new CamelInternalProcessor((Processor)producer);
        internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(null));
        this.processor = internal;
    }

    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.processor.process(exchange, callback);
    }

    public void start() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    public void stop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }

    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    public String toString() {
        return "UnitOfWork(" + this.producer + ")";
    }
}

