/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Comparator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorSupport;

public class SortProcessor<T>
extends AsyncProcessorSupport
implements IdAware,
Traceable {
    private String id;
    private final Expression expression;
    private final Comparator<? super T> comparator;

    public SortProcessor(Expression expression, Comparator<? super T> comparator) {
        this.expression = expression;
        this.comparator = comparator;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Message in = exchange.getIn();
            List list = (List)this.expression.evaluate(exchange, List.class);
            list.sort(this.comparator);
            if (exchange.getPattern().isOutCapable()) {
                Message out = exchange.getOut();
                out.copyFromWithNewBody(in, (Object)list);
            } else {
                in.setBody((Object)list);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Sort[" + this.expression + "]";
    }

    public String getTraceLabel() {
        return "sort[" + this.expression + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Comparator<? super T> getComparator() {
        return this.comparator;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

