/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.net.URISyntaxException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Traceable;
import org.apache.camel.impl.DefaultProducerCache;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.URISupport;

public class SendProcessor
extends AsyncProcessorSupport
implements Traceable,
EndpointAware,
IdAware {
    protected transient String traceLabelToString;
    protected final CamelContext camelContext;
    protected final ExchangePattern pattern;
    protected ProducerCache producerCache;
    protected AsyncProducer producer;
    protected Endpoint destination;
    protected ExchangePattern destinationExchangePattern;
    protected String id;
    protected volatile long counter;

    public SendProcessor(Endpoint destination) {
        this(destination, null);
    }

    public SendProcessor(Endpoint destination, ExchangePattern pattern) {
        ObjectHelper.notNull((Object)destination, (String)"destination");
        this.destination = destination;
        this.camelContext = destination.getCamelContext();
        this.pattern = pattern;
        try {
            this.destinationExchangePattern = null;
            this.destinationExchangePattern = EndpointHelper.resolveExchangePatternFromUrl((String)destination.getEndpointUri());
        }
        catch (URISyntaxException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
    }

    public String toString() {
        return "sendTo(" + this.destination + ")";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTraceLabel() {
        if (this.traceLabelToString == null) {
            this.traceLabelToString = URISupport.sanitizeUri((String)this.destination.getEndpointUri());
        }
        return this.traceLabelToString;
    }

    public Endpoint getEndpoint() {
        return this.destination;
    }

    public boolean process(Exchange exchange, final AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange.setException((Throwable)new IllegalStateException("SendProcessor has not been started: " + (Object)((Object)this)));
            callback.done(true);
            return true;
        }
        final ExchangePattern existingPattern = exchange.getPattern();
        ++this.counter;
        if (this.producer != null) {
            final Exchange target = this.configureExchange(exchange, this.pattern);
            boolean sending = EventHelper.notifyExchangeSending((CamelContext)exchange.getContext(), (Exchange)target, (Endpoint)this.destination);
            final StopWatch watch = sending ? new StopWatch() : null;
            try {
                this.log.debug(">>>> {} {}", (Object)this.destination, (Object)exchange);
                return this.producer.process(exchange, new AsyncCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void done(boolean doneSync) {
                        try {
                            target.setPattern(existingPattern);
                            if (watch != null) {
                                long timeTaken = watch.taken();
                                EventHelper.notifyExchangeSent((CamelContext)target.getContext(), (Exchange)target, (Endpoint)SendProcessor.this.destination, (long)timeTaken);
                            }
                        }
                        finally {
                            callback.done(doneSync);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                exchange.setException(throwable);
                callback.done(true);
                return true;
            }
        }
        this.configureExchange(exchange, this.pattern);
        this.log.debug(">>>> {} {}", (Object)this.destination, (Object)exchange);
        return this.producerCache.doInAsyncProducer(this.destination, exchange, callback, (producer, ex, cb) -> producer.process(ex, doneSync -> {
            exchange.setPattern(existingPattern);
            cb.done(doneSync);
        }));
    }

    public Endpoint getDestination() {
        return this.destination;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) {
        if (this.destinationExchangePattern != null) {
            exchange.setPattern(this.destinationExchangePattern);
        } else if (pattern != null) {
            exchange.setPattern(pattern);
        }
        exchange.setProperty("CamelToEndpoint", (Object)this.destination.getEndpointUri());
        return exchange;
    }

    public long getCounter() {
        return this.counter;
    }

    public void reset() {
        this.counter = 0L;
    }

    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new DefaultProducerCache((Object)this, this.camelContext, 1);
        }
        ServiceHelper.startService((Object)this.producerCache);
        ServiceHelper.startService((Object)this.destination);
        AsyncProducer producer = this.producerCache.acquireProducer(this.destination);
        if (!producer.isSingleton()) {
            this.producerCache.releaseProducer(this.destination, producer);
        } else {
            this.producer = producer;
        }
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.producerCache, this.producer});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.producerCache, this.producer});
    }
}

