/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.support.processor.DelegateAsyncProcessor;

public class FatalFallbackErrorHandler
extends DelegateAsyncProcessor
implements ErrorHandler {
    private boolean deadLetterChannel;

    public FatalFallbackErrorHandler(Processor processor) {
        this(processor, false);
    }

    public FatalFallbackErrorHandler(Processor processor, boolean isDeadLetterChannel) {
        super(processor);
        this.deadLetterChannel = isDeadLetterChannel;
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final String id = (String)ExpressionBuilder.routeIdExpression().evaluate(exchange, String.class);
        ArrayDeque<String> fatals = (ArrayDeque<String>)exchange.getProperty("CamelFatalFallbackErrorHandler", null, Deque.class);
        if (fatals == null) {
            fatals = new ArrayDeque<String>();
            exchange.setProperty("CamelFatalFallbackErrorHandler", fatals);
        }
        if (fatals.contains(id)) {
            this.log.warn("Circular error-handler detected at route: {} - breaking out processing Exchange: {}", (Object)id, (Object)exchange);
            exchange.setProperty("CamelErrorHandlerHandled", (Object)false);
            exchange.setProperty("CamelFErrorHandlerCircuitDetected", (Object)true);
            callback.done(true);
            return true;
        }
        fatals.push(id);
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(boolean doneSync) {
                try {
                    if (exchange.getException() != null) {
                        Throwable previous = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
                        if (previous != null && previous == exchange.getException()) {
                            previous = null;
                            if (exchange.getException().getSuppressed().length > 0) {
                                previous = exchange.getException().getSuppressed()[0];
                            }
                        }
                        String msg = "Exception occurred while trying to handle previously thrown exception on exchangeId: " + exchange.getExchangeId() + " using: [" + FatalFallbackErrorHandler.this.processor + "].";
                        if (previous != null) {
                            msg = msg + " The previous and the new exception will be logged in the following.";
                            FatalFallbackErrorHandler.this.log(msg);
                            FatalFallbackErrorHandler.this.log("\\--> Previous exception on exchangeId: " + exchange.getExchangeId(), previous);
                            FatalFallbackErrorHandler.this.log("\\--> New exception on exchangeId: " + exchange.getExchangeId(), exchange.getException());
                        } else {
                            FatalFallbackErrorHandler.this.log(msg);
                            FatalFallbackErrorHandler.this.log("\\--> New exception on exchangeId: " + exchange.getExchangeId(), exchange.getException());
                        }
                        if (previous != null) {
                            Throwable[] suppressed = exchange.getException().getSuppressed();
                            boolean found = false;
                            for (Throwable t : suppressed) {
                                if (t != previous) continue;
                                found = true;
                            }
                            if (!found) {
                                exchange.getException().addSuppressed(previous);
                            }
                        }
                        exchange.setProperty("CamelExceptionCaught", (Object)exchange.getException());
                        if (FatalFallbackErrorHandler.this.deadLetterChannel) {
                            exchange.removeProperty("CamelErrorHandlerHandled");
                        } else {
                            exchange.setProperty("CamelErrorHandlerHandled", (Object)false);
                        }
                    }
                }
                finally {
                    Deque fatals = (Deque)exchange.getProperty("CamelFatalFallbackErrorHandler", null, Deque.class);
                    if (fatals != null) {
                        fatals.removeLastOccurrence(id);
                    }
                    callback.done(doneSync);
                }
            }
        });
        return sync;
    }

    private void log(String message) {
        this.log(message, null);
    }

    private void log(String message, Throwable t) {
        if (this.deadLetterChannel) {
            if (t != null) {
                this.log.warn(message, t);
            } else {
                this.log.warn(message);
            }
        } else if (t != null) {
            this.log.error(message, t);
        } else {
            this.log.error(message);
        }
    }

    public String toString() {
        return "FatalFallbackErrorHandler[" + this.processor + "]";
    }
}

