/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ConstantStaticTypeBeanHolder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;

@Metadata(firstVersion="1.3.0", label="language,core,java", title="Bean method")
@XmlRootElement(name="method")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MethodCallExpression
extends ExpressionDefinition {
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String method;
    @XmlAttribute(name="beanType")
    private String beanTypeName;
    @XmlTransient
    private Class<?> beanType;
    @XmlTransient
    private Object instance;

    public MethodCallExpression() {
    }

    public MethodCallExpression(String beanName) {
        this(beanName, null);
    }

    public MethodCallExpression(String beanName, String method) {
        super(beanName);
        this.method = method;
    }

    public MethodCallExpression(Object instance) {
        this(instance, null);
    }

    public MethodCallExpression(Object instance, String method) {
        super(ObjectHelper.className((Object)instance));
        this.setInstance(instance);
        this.setMethod(method);
    }

    public MethodCallExpression(Class<?> type) {
        this(type, null);
    }

    public MethodCallExpression(Class<?> type, String method) {
        super(type.getName());
        this.beanType = type;
        this.method = method;
    }

    @Override
    public String getLanguage() {
        return "bean";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanType = beanType;
        this.instance = null;
    }

    public String getBeanTypeName() {
        return this.beanTypeName;
    }

    public void setBeanTypeName(String beanTypeName) {
        this.beanTypeName = beanTypeName;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        if (instance instanceof Class) {
            this.beanType = (Class)instance;
            this.instance = null;
        } else {
            this.beanType = null;
            this.instance = instance;
        }
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        BeanHolder holder;
        if (this.beanType == null && this.beanTypeName != null) {
            try {
                this.beanType = camelContext.getClassResolver().resolveMandatoryClass(this.beanTypeName);
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        if (this.beanType != null) {
            if (ObjectHelper.hasDefaultPublicNoArgConstructor(this.beanType)) {
                this.instance = camelContext.getInjector().newInstance(this.beanType);
                holder = new ConstantBeanHolder(this.instance, camelContext);
            } else {
                holder = new ConstantStaticTypeBeanHolder(this.beanType, camelContext);
            }
        } else if (this.instance != null) {
            holder = new ConstantBeanHolder(this.instance, camelContext);
        } else {
            String ref = this.beanName();
            RegistryBean regHolder = new RegistryBean(camelContext, ref);
            this.instance = regHolder.getBean();
            holder = new ConstantBeanHolder(this.instance, camelContext);
        }
        BeanExpression answer = new BeanExpression(holder, this.getMethod());
        this.validateHasMethod(camelContext, this.instance, this.beanType, this.getMethod());
        return answer;
    }

    @Override
    public Predicate createPredicate(CamelContext camelContext) {
        return (Predicate)this.createExpression(camelContext);
    }

    protected void validateHasMethod(CamelContext context, Object bean, Class<?> type, String method) {
        if (method == null) {
            return;
        }
        if (bean == null && type == null) {
            throw new IllegalArgumentException("Either bean or type should be provided on " + this);
        }
        if (OgnlHelper.isValidOgnlExpression((String)method)) {
            return;
        }
        if (OgnlHelper.isInvalidValidOgnlExpression((String)method)) {
            ExpressionIllegalSyntaxException cause = new ExpressionIllegalSyntaxException(method);
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new MethodNotFoundException((Object)(bean != null ? bean : type), method, (Throwable)cause)));
        }
        if (bean != null) {
            BeanInfo info = new BeanInfo(context, bean.getClass());
            if (!info.hasMethod(method)) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new MethodNotFoundException(null, bean, method)));
            }
        } else {
            BeanInfo info = new BeanInfo(context, type);
            if (!info.hasStaticMethod(method)) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)((Object)new MethodNotFoundException(null, type, method, true)));
            }
        }
    }

    protected String beanName() {
        if (this.ref != null) {
            return this.ref;
        }
        if (this.instance != null) {
            return ObjectHelper.className((Object)this.instance);
        }
        return this.getExpression();
    }

    @Override
    public String toString() {
        boolean isRef = this.ref != null;
        return "bean[" + (isRef ? "ref:" : "") + this.beanName() + (this.method != null ? " method:" + this.method : "") + "]";
    }
}

