/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.support.jsse.KeyStoreParameters;

@Metadata(firstVersion="2.0.0", label="dataformat,transformation,xml,security", title="XML Security")
@XmlRootElement(name="secureXML")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XMLSecurityDataFormat
extends DataFormatDefinition
implements NamespaceAware {
    private static final String TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    @XmlAttribute
    @Metadata(defaultValue="TRIPLEDES")
    private String xmlCipherAlgorithm;
    @XmlAttribute
    private String passPhrase;
    @XmlAttribute
    private byte[] passPhraseByte;
    @XmlAttribute
    private String secureTag;
    @XmlAttribute
    private Boolean secureTagContents;
    @XmlAttribute
    @Metadata(defaultValue="RSA_OAEP")
    private String keyCipherAlgorithm;
    @XmlAttribute
    private String recipientKeyAlias;
    @XmlAttribute
    private String keyOrTrustStoreParametersRef;
    @XmlAttribute
    private String keyPassword;
    @XmlAttribute
    @Metadata(defaultValue="SHA1")
    private String digestAlgorithm;
    @XmlAttribute
    @Metadata(defaultValue="MGF1_SHA1")
    private String mgfAlgorithm;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean addKeyValueForEncryptedKey;
    @XmlTransient
    private KeyStoreParameters keyOrTrustStoreParameters;
    @XmlTransient
    private Map<String, String> namespaces;

    public XMLSecurityDataFormat() {
        super("secureXML");
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.getSecureTag() != null) {
            this.setProperty(camelContext, dataFormat, "secureTag", this.getSecureTag());
        } else {
            this.setProperty(camelContext, dataFormat, "secureTag", "");
        }
        boolean isSecureTagContents = this.getSecureTagContents() != null && this.getSecureTagContents() != false;
        this.setProperty(camelContext, dataFormat, "secureTagContents", isSecureTagContents);
        if (this.passPhrase != null || this.passPhraseByte != null) {
            if (this.passPhraseByte != null) {
                this.setProperty(camelContext, dataFormat, "passPhrase", this.passPhraseByte);
            } else {
                this.setProperty(camelContext, dataFormat, "passPhrase", this.passPhrase.getBytes());
            }
        } else {
            this.setProperty(camelContext, dataFormat, "passPhrase", "Just another 24 Byte key".getBytes());
        }
        if (this.getXmlCipherAlgorithm() != null) {
            this.setProperty(camelContext, dataFormat, "xmlCipherAlgorithm", this.getXmlCipherAlgorithm());
        } else {
            this.setProperty(camelContext, dataFormat, "xmlCipherAlgorithm", TRIPLEDES);
        }
        if (this.getKeyCipherAlgorithm() != null) {
            this.setProperty(camelContext, dataFormat, "keyCipherAlgorithm", this.getKeyCipherAlgorithm());
        }
        if (this.getRecipientKeyAlias() != null) {
            this.setProperty(camelContext, dataFormat, "recipientKeyAlias", this.getRecipientKeyAlias());
        }
        if (this.getKeyOrTrustStoreParametersRef() != null) {
            this.setProperty(camelContext, dataFormat, "keyOrTrustStoreParametersRef", this.getKeyOrTrustStoreParametersRef());
        }
        if (this.keyOrTrustStoreParameters != null) {
            this.setProperty(camelContext, dataFormat, "keyOrTrustStoreParameters", this.keyOrTrustStoreParameters);
        }
        if (this.namespaces != null) {
            this.setProperty(camelContext, dataFormat, "namespaces", this.namespaces);
        }
        if (this.keyPassword != null) {
            this.setProperty(camelContext, dataFormat, "keyPassword", this.getKeyPassword());
        }
        if (this.digestAlgorithm != null) {
            this.setProperty(camelContext, dataFormat, "digestAlgorithm", this.getDigestAlgorithm());
        }
        if (this.mgfAlgorithm != null) {
            this.setProperty(camelContext, dataFormat, "mgfAlgorithm", this.getMgfAlgorithm());
        }
        boolean isAddKeyValueForEncryptedKey = this.getAddKeyValueForEncryptedKey() == null || this.getAddKeyValueForEncryptedKey() != false;
        this.setProperty(camelContext, dataFormat, "addKeyValueForEncryptedKey", isAddKeyValueForEncryptedKey);
    }

    public String getXmlCipherAlgorithm() {
        return this.xmlCipherAlgorithm;
    }

    public void setXmlCipherAlgorithm(String xmlCipherAlgorithm) {
        this.xmlCipherAlgorithm = xmlCipherAlgorithm;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public byte[] getPassPhraseByte() {
        return this.passPhraseByte;
    }

    public void setPassPhraseByte(byte[] passPhraseByte) {
        this.passPhraseByte = passPhraseByte;
    }

    public String getSecureTag() {
        return this.secureTag;
    }

    public void setSecureTag(String secureTag) {
        this.secureTag = secureTag;
    }

    public Boolean getSecureTagContents() {
        return this.secureTagContents;
    }

    public void setSecureTagContents(Boolean secureTagContents) {
        this.secureTagContents = secureTagContents;
    }

    public void setKeyCipherAlgorithm(String keyCipherAlgorithm) {
        this.keyCipherAlgorithm = keyCipherAlgorithm;
    }

    public String getKeyCipherAlgorithm() {
        return this.keyCipherAlgorithm;
    }

    public void setRecipientKeyAlias(String recipientKeyAlias) {
        this.recipientKeyAlias = recipientKeyAlias;
    }

    public String getRecipientKeyAlias() {
        return this.recipientKeyAlias;
    }

    public void setKeyOrTrustStoreParametersRef(String id) {
        this.keyOrTrustStoreParametersRef = id;
    }

    public String getKeyOrTrustStoreParametersRef() {
        return this.keyOrTrustStoreParametersRef;
    }

    public KeyStoreParameters getKeyOrTrustStoreParameters() {
        return this.keyOrTrustStoreParameters;
    }

    public void setKeyOrTrustStoreParameters(KeyStoreParameters keyOrTrustStoreParameters) {
        this.keyOrTrustStoreParameters = keyOrTrustStoreParameters;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public String getMgfAlgorithm() {
        return this.mgfAlgorithm;
    }

    public void setMgfAlgorithm(String mgfAlgorithm) {
        this.mgfAlgorithm = mgfAlgorithm;
    }

    public Boolean getAddKeyValueForEncryptedKey() {
        return this.addKeyValueForEncryptedKey;
    }

    public void setAddKeyValueForEncryptedKey(Boolean addKeyValueForEncryptedKey) {
        this.addKeyValueForEncryptedKey = addKeyValueForEncryptedKey;
    }

    public void setNamespaces(Map<String, String> nspaces) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        this.namespaces.putAll(nspaces);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }
}

