/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;

@Metadata(firstVersion="2.6.0", label="dataformat,transformation,xml", title="JiBX")
@XmlRootElement(name="jibx")
@XmlAccessorType(value=XmlAccessType.NONE)
public class JibxDataFormat
extends DataFormatDefinition {
    @XmlAttribute(name="unmarshallClass")
    private String unmarshallTypeName;
    @XmlAttribute
    private String bindingName;
    @XmlTransient
    private Class<?> unmarshallClass;

    public JibxDataFormat() {
        super("jibx");
    }

    public JibxDataFormat(Class<?> unmarshallClass) {
        this();
        this.setUnmarshallClass(unmarshallClass);
    }

    public Class<?> getUnmarshallClass() {
        return this.unmarshallClass;
    }

    public void setUnmarshallClass(Class<?> unmarshallClass) {
        this.unmarshallClass = unmarshallClass;
    }

    public String getUnmarshallTypeName() {
        return this.unmarshallTypeName;
    }

    public void setUnmarshallTypeName(String unmarshallTypeName) {
        this.unmarshallTypeName = unmarshallTypeName;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.unmarshallClass == null && this.unmarshallTypeName != null) {
            try {
                this.unmarshallClass = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.unmarshallTypeName);
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        return super.createDataFormat(routeContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.unmarshallClass != null) {
            this.setProperty(camelContext, dataFormat, "unmarshallClass", this.unmarshallClass);
        }
        if (this.bindingName != null) {
            this.setProperty(camelContext, dataFormat, "bindingName", this.bindingName);
        }
    }
}

