/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.cloud.ServiceExpressionFactory;
import org.apache.camel.impl.cloud.DefaultServiceCallExpression;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="routing,cloud")
@XmlRootElement(name="serviceExpression")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceCallExpressionConfiguration
extends IdentifiedType
implements ServiceExpressionFactory {
    @XmlTransient
    private final ServiceCallDefinition parent;
    @XmlTransient
    private final String factoryKey;
    @XmlElement(name="properties")
    @Metadata(label="advanced")
    private List<PropertyDefinition> properties;
    @XmlAttribute
    @Metadata(defaultValue="CamelServiceCallServiceHost")
    private String hostHeader = "CamelServiceCallServiceHost";
    @XmlAttribute
    @Metadata(defaultValue="CamelServiceCallServicePort")
    private String portHeader = "CamelServiceCallServicePort";
    @XmlElementRef(required=false)
    private ExpressionDefinition expressionType;
    @XmlTransient
    private Expression expression;

    public ServiceCallExpressionConfiguration() {
        this(null, null);
    }

    public ServiceCallExpressionConfiguration(ServiceCallDefinition parent, String factoryKey) {
        this.parent = parent;
        this.factoryKey = factoryKey;
    }

    public ServiceCallDefinition end() {
        return this.parent;
    }

    public ProcessorDefinition<?> endParent() {
        return this.parent.end();
    }

    public List<PropertyDefinition> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyDefinition> properties) {
        this.properties = properties;
    }

    public ServiceCallExpressionConfiguration property(String key, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyDefinition>();
        }
        PropertyDefinition prop = new PropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.properties.add(prop);
        return this;
    }

    protected Map<String, String> getPropertiesAsMap(CamelContext camelContext) throws Exception {
        Map<String, String> answer;
        if (this.properties == null || this.properties.isEmpty()) {
            answer = Collections.emptyMap();
        } else {
            answer = new HashMap<String, String>();
            for (PropertyDefinition prop : this.properties) {
                String key = CamelContextHelper.parseText((CamelContext)camelContext, (String)prop.getKey());
                String value = CamelContextHelper.parseText((CamelContext)camelContext, (String)prop.getValue());
                answer.put(key, value);
            }
        }
        return answer;
    }

    public String getHostHeader() {
        return this.hostHeader;
    }

    public void setHostHeader(String hostHeader) {
        this.hostHeader = hostHeader;
    }

    public String getPortHeader() {
        return this.portHeader;
    }

    public void setPortHeader(String portHeader) {
        this.portHeader = portHeader;
    }

    public ExpressionDefinition getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(ExpressionDefinition expressionType) {
        this.expressionType = expressionType;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public ServiceCallExpressionConfiguration hostHeader(String hostHeader) {
        this.setHostHeader(hostHeader);
        return this;
    }

    public ServiceCallExpressionConfiguration portHeader(String portHeader) {
        this.setPortHeader(portHeader);
        return this;
    }

    public ServiceCallExpressionConfiguration expressionType(ExpressionDefinition expressionType) {
        this.setExpressionType(expressionType);
        return this;
    }

    public ServiceCallExpressionConfiguration expression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression newInstance(CamelContext camelContext) throws Exception {
        void var2_7;
        Expression expression = this.getExpression();
        if (expression != null) {
            return expression;
        }
        ExpressionDefinition expressionType = this.getExpressionType();
        if (expressionType != null && expression == null) {
            return expressionType.createExpression(camelContext);
        }
        if (this.factoryKey != null) {
            Class type;
            ServiceExpressionFactory factory = (ServiceExpressionFactory)CamelContextHelper.lookup((CamelContext)camelContext, (String)this.factoryKey, ServiceExpressionFactory.class);
            if (factory != null) {
                Expression expression2 = (Expression)factory.newInstance(camelContext);
                return var2_7;
            }
            try {
                type = camelContext.getFactoryFinder("META-INF/services/org/apache/camel/cloud/").findClass(this.factoryKey);
            }
            catch (Exception e) {
                throw new NoFactoryAvailableException("META-INF/services/org/apache/camel/cloud/" + this.factoryKey, (Throwable)e);
            }
            if (type != null) {
                if (!ServiceExpressionFactory.class.isAssignableFrom(type)) throw new IllegalArgumentException("Resolving Expression: " + this.factoryKey + " detected type conflict: Not a ExpressionFactory implementation. Found: " + type.getName());
                factory = (ServiceExpressionFactory)camelContext.getInjector().newInstance(type);
            }
            try {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                IntrospectionSupport.getProperties((Object)this, parameters, null, (boolean)false);
                parameters.replaceAll((k, v) -> {
                    if (v instanceof String) {
                        try {
                            v = camelContext.resolvePropertyPlaceholders((String)v);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Exception while resolving %s (%s)", k, v.toString()), e);
                        }
                    }
                    return v;
                });
                parameters.put("properties", this.getPropertiesAsMap(camelContext));
                this.postProcessFactoryParameters(camelContext, parameters);
                IntrospectionSupport.setProperties((Object)factory, parameters);
                Expression expression3 = (Expression)factory.newInstance(camelContext);
                return var2_7;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        DefaultServiceCallExpression defaultServiceCallExpression = new DefaultServiceCallExpression((String)ObjectHelper.notNull((Object)this.hostHeader, (String)"hostHeader"), (String)ObjectHelper.notNull((Object)this.portHeader, (String)"portHeader"));
        return var2_7;
    }

    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
    }
}

