/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.DataFormatClause;
import org.apache.camel.builder.EnrichClause;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.ProcessClause;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.Block;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ClaimCheckDefinition;
import org.apache.camel.model.ClaimCheckOperation;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.HystrixDefinition;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.OtherAttributesAware;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RemoveHeaderDefinition;
import org.apache.camel.model.RemoveHeadersDefinition;
import org.apache.camel.model.RemovePropertiesDefinition;
import org.apache.camel.model.RemovePropertyDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RollbackDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.SamplingDefinition;
import org.apache.camel.model.ScriptDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SetExchangePatternDefinition;
import org.apache.camel.model.SetFaultBodyDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetPropertyDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.model.StopDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.model.ThrowExceptionDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.ValidateDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.dataformat.CustomDataFormat;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.AsEndpointUri;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Policy;
import org.apache.camel.support.ExpressionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class ProcessorDefinition<Type extends ProcessorDefinition<Type>>
extends OptionalIdentifiedDefinition<Type>
implements Block,
OtherAttributesAware {
    @XmlTransient
    private static final AtomicInteger COUNTER = new AtomicInteger();
    @XmlTransient
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @XmlAttribute
    protected Boolean inheritErrorHandler;
    @XmlTransient
    private final LinkedList<Block> blocks = new LinkedList();
    @XmlTransient
    private ProcessorDefinition<?> parent;
    @XmlTransient
    private final List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    @XmlAnyAttribute
    private Map<QName, Object> otherAttributes;
    @XmlTransient
    private final int index = COUNTER.getAndIncrement();

    protected ProcessorDefinition() {
    }

    public int getIndex() {
        return this.index;
    }

    public abstract List<ProcessorDefinition<?>> getOutputs();

    public abstract boolean isOutputSupported();

    public boolean isTopLevelOnly() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isWrappingEntireOutput() {
        return false;
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        if (!this.isOutputSupported()) {
            this.getParent().addOutput(output);
            return;
        }
        if (!this.blocks.isEmpty()) {
            Block block = this.blocks.getLast();
            block.addOutput(output);
            return;
        }
        boolean parentIsRoute = RouteDefinition.class.isAssignableFrom(this.getClass());
        if (output.isTopLevelOnly() && !parentIsRoute) {
            throw new IllegalArgumentException("The output must be added as top-level on the route. Try moving " + output + " to the top of route.");
        }
        output.setParent(this);
        this.configureChild(output);
        this.getOutputs().add(output);
    }

    public void clearOutput() {
        this.getOutputs().clear();
        this.blocks.clear();
    }

    public void preCreateProcessor() {
    }

    public void configureChild(ProcessorDefinition<?> output) {
    }

    public Type placeholder(String option, String key) {
        QName name = new QName("http://camel.apache.org/schema/placeholder", option);
        return this.attribute(name, key);
    }

    public Type attribute(QName name, Object value) {
        if (this.otherAttributes == null) {
            this.otherAttributes = new HashMap<QName, Object>();
        }
        this.otherAttributes.put(name, value);
        return (Type)this;
    }

    public Type to(@AsEndpointUri String uri) {
        this.addOutput(new ToDefinition(uri));
        return (Type)this;
    }

    public Type toD(@AsEndpointUri String uri) {
        ToDynamicDefinition answer = new ToDynamicDefinition();
        answer.setUri(uri);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type toD(@AsEndpointUri String uri, int cacheSize) {
        ToDynamicDefinition answer = new ToDynamicDefinition();
        answer.setUri(uri);
        answer.setCacheSize(cacheSize);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type toD(@AsEndpointUri String uri, boolean ignoreInvalidEndpoint) {
        ToDynamicDefinition answer = new ToDynamicDefinition();
        answer.setUri(uri);
        answer.setIgnoreInvalidEndpoint(ignoreInvalidEndpoint);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type toF(@AsEndpointUri String uri, Object ... args) {
        this.addOutput(new ToDefinition(String.format(uri, args)));
        return (Type)this;
    }

    public ServiceCallDefinition serviceCall() {
        ServiceCallDefinition answer = new ServiceCallDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type serviceCall(String name) {
        ServiceCallDefinition answer = new ServiceCallDefinition();
        answer.setName(name);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type serviceCall(String name, @AsEndpointUri String uri) {
        ServiceCallDefinition answer = new ServiceCallDefinition();
        answer.setName(name);
        answer.setUri(uri);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type to(Endpoint endpoint) {
        this.addOutput(new ToDefinition(endpoint));
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, @AsEndpointUri String uri) {
        this.addOutput(new ToDefinition(uri, pattern));
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, Endpoint endpoint) {
        this.addOutput(new ToDefinition(endpoint, pattern));
        return (Type)this;
    }

    public Type to(String ... uris) {
        for (String uri : uris) {
            this.addOutput(new ToDefinition(uri));
        }
        return (Type)this;
    }

    public Type to(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint));
        }
        return (Type)this;
    }

    public Type to(Iterable<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint));
        }
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, String ... uris) {
        for (String uri : uris) {
            this.addOutput(new ToDefinition(uri, pattern));
        }
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint, pattern));
        }
        return (Type)this;
    }

    public Type to(ExchangePattern pattern, Iterable<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint, pattern));
        }
        return (Type)this;
    }

    public Type setExchangePattern(ExchangePattern exchangePattern) {
        this.addOutput(new SetExchangePatternDefinition(exchangePattern));
        return (Type)this;
    }

    public Type inOnly(@AsEndpointUri String uri) {
        return this.to(ExchangePattern.InOnly, uri);
    }

    public Type inOnly(Endpoint endpoint) {
        return this.to(ExchangePattern.InOnly, endpoint);
    }

    public Type inOnly(String ... uris) {
        return this.to(ExchangePattern.InOnly, uris);
    }

    public Type inOnly(Endpoint ... endpoints) {
        return this.to(ExchangePattern.InOnly, endpoints);
    }

    public Type inOnly(Iterable<Endpoint> endpoints) {
        return this.to(ExchangePattern.InOnly, endpoints);
    }

    public Type inOut(@AsEndpointUri String uri) {
        return this.to(ExchangePattern.InOut, uri);
    }

    public Type inOut(Endpoint endpoint) {
        return this.to(ExchangePattern.InOut, endpoint);
    }

    public Type inOut(String ... uris) {
        return this.to(ExchangePattern.InOut, uris);
    }

    public Type inOut(Endpoint ... endpoints) {
        return this.to(ExchangePattern.InOut, endpoints);
    }

    public Type inOut(Iterable<Endpoint> endpoints) {
        return this.to(ExchangePattern.InOut, endpoints);
    }

    @Override
    public Type id(String id) {
        if (this.isOutputSupported() && this.getOutputs().isEmpty()) {
            this.setId(id);
        } else {
            ProcessorDefinition block;
            List<ProcessorDefinition<?>> outputs = this.getOutputs();
            if (!this.blocks.isEmpty() && this.blocks.getLast() instanceof ProcessorDefinition && !(block = (ProcessorDefinition)this.blocks.getLast()).getOutputs().isEmpty()) {
                outputs = block.getOutputs();
            }
            if (!this.getOutputs().isEmpty()) {
                outputs.get(outputs.size() - 1).setId(id);
            } else {
                this.setId(id);
            }
        }
        return (Type)this;
    }

    public Type routeId(String id) {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            route.setId(id);
        }
        return (Type)this;
    }

    public Type routeGroup(String group) {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            route.setGroup(group);
        }
        return (Type)this;
    }

    public Type routeDescription(String description) {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            DescriptionDefinition desc = new DescriptionDefinition();
            desc.setText(description);
            route.setDescription(desc);
        }
        return (Type)this;
    }

    public MulticastDefinition multicast() {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        return answer;
    }

    public MulticastDefinition multicast(AggregationStrategy aggregationStrategy, boolean parallelProcessing) {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        answer.setParallelProcessing(parallelProcessing);
        return answer;
    }

    public MulticastDefinition multicast(AggregationStrategy aggregationStrategy) {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return answer;
    }

    public StepDefinition step() {
        StepDefinition answer = new StepDefinition();
        this.addOutput(answer);
        return answer;
    }

    public StepDefinition step(String id) {
        StepDefinition answer = new StepDefinition();
        answer.setId(id);
        this.addOutput(answer);
        return answer;
    }

    public PipelineDefinition pipeline() {
        PipelineDefinition answer = new PipelineDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type pipeline(String ... uris) {
        PipelineDefinition answer = new PipelineDefinition();
        this.addOutput(answer);
        answer.to(uris);
        return (Type)this;
    }

    public Type pipeline(Endpoint ... endpoints) {
        PipelineDefinition answer = new PipelineDefinition();
        this.addOutput(answer);
        answer.to(endpoints);
        return (Type)this;
    }

    public Type pipeline(Collection<Endpoint> endpoints) {
        PipelineDefinition answer = new PipelineDefinition();
        this.addOutput(answer);
        answer.to(endpoints);
        return (Type)this;
    }

    public ThreadsDefinition threads() {
        ThreadsDefinition answer = new ThreadsDefinition();
        this.addOutput(answer);
        return answer;
    }

    public ThreadsDefinition threads(int poolSize) {
        ThreadsDefinition answer = new ThreadsDefinition();
        answer.setPoolSize(poolSize);
        this.addOutput(answer);
        return answer;
    }

    public ThreadsDefinition threads(int poolSize, int maxPoolSize) {
        ThreadsDefinition answer = new ThreadsDefinition();
        answer.setPoolSize(poolSize);
        answer.setMaxPoolSize(maxPoolSize);
        this.addOutput(answer);
        return answer;
    }

    public ThreadsDefinition threads(int poolSize, int maxPoolSize, String threadName) {
        ThreadsDefinition answer = new ThreadsDefinition();
        answer.setPoolSize(poolSize);
        answer.setMaxPoolSize(maxPoolSize);
        answer.setThreadName(threadName);
        this.addOutput(answer);
        return answer;
    }

    public ProcessorDefinition<?> end() {
        ProcessorDefinition defn = this;
        if (defn instanceof TryDefinition || defn instanceof ChoiceDefinition) {
            this.popBlock();
        }
        if (this.blocks.isEmpty()) {
            if (this.parent == null) {
                return this.endParent();
            }
            return this.parent.endParent();
        }
        this.popBlock();
        return this.endParent();
    }

    public ProcessorDefinition<?> endParent() {
        return this;
    }

    public ChoiceDefinition endChoice() {
        ProcessorDefinition<?> def = this;
        if (def.getParent() instanceof WhenDefinition) {
            return (ChoiceDefinition)def.getParent().getParent();
        }
        if (def instanceof ChoiceDefinition) {
            return (ChoiceDefinition)def;
        }
        def = this.end();
        if (def instanceof WhenDefinition) {
            return (ChoiceDefinition)def.getParent();
        }
        if (def instanceof OtherwiseDefinition) {
            return (ChoiceDefinition)def.getParent();
        }
        return (ChoiceDefinition)def;
    }

    public RestDefinition endRest() {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            return route.getRestDefinition();
        }
        throw new IllegalArgumentException("Cannot find RouteDefinition to allow endRest");
    }

    public TryDefinition endDoTry() {
        ProcessorDefinition<?> def = this;
        if (def instanceof TryDefinition) {
            return (TryDefinition)def;
        }
        def = this.end();
        return (TryDefinition)def;
    }

    public HystrixDefinition endHystrix() {
        ProcessorDefinition<?> def = this;
        if (def instanceof HystrixDefinition) {
            return (HystrixDefinition)def;
        }
        def = this.end();
        return (HystrixDefinition)def;
    }

    public ExpressionClause<IdempotentConsumerDefinition> idempotentConsumer() {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public IdempotentConsumerDefinition idempotentConsumer(Expression messageIdExpression) {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition();
        answer.setExpression(ExpressionNodeHelper.toExpressionDefinition(messageIdExpression));
        this.addOutput(answer);
        return answer;
    }

    public IdempotentConsumerDefinition idempotentConsumer(Expression messageIdExpression, IdempotentRepository idempotentRepository) {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition(messageIdExpression, idempotentRepository);
        this.addOutput(answer);
        return answer;
    }

    @AsPredicate
    public ExpressionClause<? extends FilterDefinition> filter() {
        FilterDefinition filter = new FilterDefinition();
        this.addOutput(filter);
        return ExpressionClause.createAndSetExpression(filter);
    }

    public FilterDefinition filter(@AsPredicate Predicate predicate) {
        FilterDefinition filter = new FilterDefinition(predicate);
        this.addOutput(filter);
        return filter;
    }

    public FilterDefinition filter(@AsPredicate ExpressionDefinition expression) {
        FilterDefinition filter = new FilterDefinition(expression);
        this.addOutput(filter);
        return filter;
    }

    public FilterDefinition filter(String language, @AsPredicate String expression) {
        return this.filter(new LanguageExpression(language, expression));
    }

    public ValidateDefinition validate(@AsPredicate Expression expression) {
        ValidateDefinition answer = new ValidateDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public ValidateDefinition validate(@AsPredicate Predicate predicate) {
        ValidateDefinition answer = new ValidateDefinition(predicate);
        this.addOutput(answer);
        return answer;
    }

    @AsPredicate
    public ExpressionClause<ValidateDefinition> validate() {
        ValidateDefinition answer = new ValidateDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public HystrixDefinition hystrix() {
        HystrixDefinition answer = new HystrixDefinition();
        this.addOutput(answer);
        return answer;
    }

    public LoadBalanceDefinition loadBalance() {
        LoadBalanceDefinition answer = new LoadBalanceDefinition();
        this.addOutput(answer);
        return answer;
    }

    public LoadBalanceDefinition loadBalance(LoadBalancer loadBalancer) {
        LoadBalanceDefinition answer = new LoadBalanceDefinition();
        this.addOutput(answer);
        return answer.loadBalance(loadBalancer);
    }

    public Type log(String message) {
        LogDefinition answer = new LogDefinition(message);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type log(LoggingLevel loggingLevel, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type log(LoggingLevel loggingLevel, String logName, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel);
        answer.setLogName(logName);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type log(LoggingLevel loggingLevel, Logger logger, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel);
        answer.setLogger(logger);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type log(LoggingLevel loggingLevel, String logName, String marker, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel);
        answer.setLogName(logName);
        answer.setMarker(marker);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type log(LoggingLevel loggingLevel, Logger logger, String marker, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel);
        answer.setLogger(logger);
        answer.setMarker(marker);
        this.addOutput(answer);
        return (Type)this;
    }

    public ChoiceDefinition choice() {
        ChoiceDefinition answer = new ChoiceDefinition();
        this.addOutput(answer);
        return answer;
    }

    public TryDefinition doTry() {
        TryDefinition answer = new TryDefinition();
        this.addOutput(answer);
        return answer;
    }

    public RecipientListDefinition<Type> recipientList(@AsEndpointUri Expression recipients) {
        RecipientListDefinition answer = new RecipientListDefinition(recipients);
        this.addOutput(answer);
        return answer;
    }

    public RecipientListDefinition<Type> recipientList(@AsEndpointUri Expression recipients, String delimiter) {
        RecipientListDefinition answer = new RecipientListDefinition(recipients);
        answer.setDelimiter(delimiter);
        this.addOutput(answer);
        return answer;
    }

    @AsEndpointUri
    public ExpressionClause<RecipientListDefinition<Type>> recipientList(String delimiter) {
        RecipientListDefinition answer = new RecipientListDefinition();
        answer.setDelimiter(delimiter);
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    @AsEndpointUri
    public ExpressionClause<RecipientListDefinition<Type>> recipientList() {
        RecipientListDefinition answer = new RecipientListDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public RoutingSlipDefinition<Type> routingSlip(@AsEndpointUri Expression expression, String uriDelimiter) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(expression, uriDelimiter);
        this.addOutput(answer);
        return answer;
    }

    public RoutingSlipDefinition<Type> routingSlip(@AsEndpointUri Expression expression) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<RoutingSlipDefinition<Type>> routingSlip() {
        RoutingSlipDefinition answer = new RoutingSlipDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public DynamicRouterDefinition<Type> dynamicRouter(@AsEndpointUri Expression expression) {
        DynamicRouterDefinition answer = new DynamicRouterDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    @AsEndpointUri
    public ExpressionClause<DynamicRouterDefinition<Type>> dynamicRouter() {
        DynamicRouterDefinition answer = new DynamicRouterDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public SamplingDefinition sample() {
        return this.sample(1L, TimeUnit.SECONDS);
    }

    public SamplingDefinition sample(long samplePeriod, TimeUnit unit) {
        SamplingDefinition answer = new SamplingDefinition(samplePeriod, unit);
        this.addOutput(answer);
        return answer;
    }

    public SamplingDefinition sample(long messageFrequency) {
        SamplingDefinition answer = new SamplingDefinition(messageFrequency);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<SplitDefinition> split() {
        SplitDefinition answer = new SplitDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public SplitDefinition split(Expression expression) {
        SplitDefinition answer = new SplitDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public SplitDefinition split(Expression expression, AggregationStrategy aggregationStrategy) {
        SplitDefinition answer = new SplitDefinition(expression);
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return answer;
    }

    public ExpressionClause<ResequenceDefinition> resequence() {
        ResequenceDefinition answer = new ResequenceDefinition();
        ExpressionClause<ResequenceDefinition> clause = new ExpressionClause<ResequenceDefinition>(answer);
        answer.setExpression(clause);
        this.addOutput(answer);
        return clause;
    }

    public ResequenceDefinition resequence(Expression expression) {
        ResequenceDefinition answer = new ResequenceDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<AggregateDefinition> aggregate() {
        AggregateDefinition answer = new AggregateDefinition();
        ExpressionClause<AggregateDefinition> clause = new ExpressionClause<AggregateDefinition>(answer);
        answer.setExpression(clause);
        this.addOutput(answer);
        return clause;
    }

    public ExpressionClause<AggregateDefinition> aggregate(AggregationStrategy aggregationStrategy) {
        AggregateDefinition answer = new AggregateDefinition();
        ExpressionClause<AggregateDefinition> clause = new ExpressionClause<AggregateDefinition>(answer);
        answer.setExpression(clause);
        answer.setAggregationStrategy(aggregationStrategy);
        this.addOutput(answer);
        return clause;
    }

    public AggregateDefinition aggregate(Expression correlationExpression) {
        AggregateDefinition answer = new AggregateDefinition(correlationExpression);
        this.addOutput(answer);
        return answer;
    }

    public AggregateDefinition aggregate(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        AggregateDefinition answer = new AggregateDefinition(correlationExpression, aggregationStrategy);
        this.addOutput(answer);
        return answer;
    }

    public DelayDefinition delay(Expression delay) {
        DelayDefinition answer = new DelayDefinition(delay);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<DelayDefinition> delay() {
        DelayDefinition answer = new DelayDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public DelayDefinition delay(long delay) {
        return this.delay(ExpressionBuilder.constantExpression(delay));
    }

    public ExpressionClause<ThrottleDefinition> throttle() {
        ThrottleDefinition answer = new ThrottleDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public ThrottleDefinition throttle(long maximumRequestCount) {
        return this.throttle(ExpressionBuilder.constantExpression(maximumRequestCount));
    }

    public ThrottleDefinition throttle(Expression maximumRequestCount) {
        ThrottleDefinition answer = new ThrottleDefinition(maximumRequestCount);
        this.addOutput(answer);
        return answer;
    }

    public ThrottleDefinition throttle(Expression maximumRequestCount, long correlationExpressionKey) {
        ThrottleDefinition answer = new ThrottleDefinition(maximumRequestCount, ExpressionBuilder.constantExpression(correlationExpressionKey));
        this.addOutput(answer);
        return answer;
    }

    public ThrottleDefinition throttle(Expression maximumRequestCount, Expression correlationExpressionKey) {
        ThrottleDefinition answer = new ThrottleDefinition(maximumRequestCount, correlationExpressionKey);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<LoopDefinition> loop() {
        LoopDefinition loop = new LoopDefinition();
        this.addOutput(loop);
        return ExpressionClause.createAndSetExpression(loop);
    }

    public LoopDefinition loop(Expression expression) {
        LoopDefinition loop = new LoopDefinition(expression);
        this.addOutput(loop);
        return loop;
    }

    public LoopDefinition loopDoWhile(@AsPredicate Predicate predicate) {
        LoopDefinition loop = new LoopDefinition(predicate);
        this.addOutput(loop);
        return loop;
    }

    public ExpressionClause<LoopDefinition> loopDoWhile() {
        LoopDefinition loop = new LoopDefinition();
        loop.setDoWhile(true);
        this.addOutput(loop);
        return ExpressionClause.createAndSetExpression(loop);
    }

    public LoopDefinition loop(int count) {
        LoopDefinition loop = new LoopDefinition(new ConstantExpression(Integer.toString(count)));
        this.addOutput(loop);
        return loop;
    }

    public Type throwException(Exception exception) {
        ThrowExceptionDefinition answer = new ThrowExceptionDefinition();
        answer.setException(exception);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type throwException(Class<? extends Exception> type, String message) {
        ThrowExceptionDefinition answer = new ThrowExceptionDefinition();
        answer.setExceptionClass(type);
        answer.setMessage(message);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type markRollbackOnly() {
        RollbackDefinition answer = new RollbackDefinition();
        answer.setMarkRollbackOnly(true);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type markRollbackOnlyLast() {
        RollbackDefinition answer = new RollbackDefinition();
        answer.setMarkRollbackOnlyLast(true);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type rollback() {
        return this.rollback(null);
    }

    public Type rollback(String message) {
        RollbackDefinition answer = new RollbackDefinition(message);
        this.addOutput(answer);
        return (Type)this;
    }

    public WireTapDefinition<Type> wireTap(Endpoint endpoint) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(endpoint.getEndpointUri());
        this.addOutput(answer);
        return answer;
    }

    public WireTapDefinition<Type> wireTap(@AsEndpointUri String uri) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(uri);
        this.addOutput(answer);
        return answer;
    }

    void pushBlock(Block block) {
        this.blocks.add(block);
    }

    Block popBlock() {
        return this.blocks.isEmpty() ? null : this.blocks.removeLast();
    }

    public Type startupOrder(int startupOrder) {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            route.startupOrder(startupOrder);
        }
        return (Type)this;
    }

    public Type stop() {
        StopDefinition stop = new StopDefinition();
        this.addOutput(stop);
        return (Type)this;
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> exceptionType) {
        OnExceptionDefinition answer = new OnExceptionDefinition(exceptionType);
        answer.setRouteScoped(true);
        this.addOutput(answer);
        return answer;
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> ... exceptions) {
        OnExceptionDefinition answer = new OnExceptionDefinition(Arrays.asList(exceptions));
        answer.setRouteScoped(true);
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition policy(Policy policy) {
        PolicyDefinition answer = new PolicyDefinition(policy);
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition policy(String ref) {
        PolicyDefinition answer = new PolicyDefinition();
        answer.setRef(ref);
        this.addOutput(answer);
        return answer;
    }

    public TransactedDefinition transacted() {
        TransactedDefinition answer = new TransactedDefinition();
        this.addOutput(answer);
        return answer;
    }

    public TransactedDefinition transacted(String ref) {
        TransactedDefinition answer = new TransactedDefinition();
        answer.setRef(ref);
        this.addOutput(answer);
        return answer;
    }

    public SagaDefinition saga() {
        SagaDefinition answer = new SagaDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type process(Processor processor) {
        ProcessDefinition answer = new ProcessDefinition(processor);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type process(String ref) {
        ProcessDefinition answer = new ProcessDefinition();
        answer.setRef(ref);
        this.addOutput(answer);
        return (Type)this;
    }

    public ProcessClause<ProcessorDefinition<Type>> process() {
        ProcessClause<ProcessorDefinition<Type>> clause = new ProcessClause<ProcessorDefinition<Type>>(this);
        ProcessDefinition answer = new ProcessDefinition(clause);
        this.addOutput(answer);
        return clause;
    }

    public Type bean(Object bean) {
        BeanDefinition answer = new BeanDefinition();
        if (bean instanceof String) {
            answer.setRef((String)bean);
        } else {
            answer.setBean(bean);
        }
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean, String method) {
        BeanDefinition answer = new BeanDefinition();
        if (bean instanceof String) {
            answer.setRef((String)bean);
        } else {
            answer.setBean(bean);
        }
        answer.setMethod(method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean, boolean cache) {
        BeanDefinition answer = new BeanDefinition();
        if (bean instanceof String) {
            answer.setRef((String)bean);
        } else {
            answer.setBean(bean);
        }
        answer.setCache(cache);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean, String method, boolean cache) {
        BeanDefinition answer = new BeanDefinition();
        if (bean instanceof String) {
            answer.setRef((String)bean);
        } else {
            answer.setBean(bean);
        }
        answer.setMethod(method);
        answer.setCache(cache);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class<?> beanType) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class<?> beanType, String method) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType);
        answer.setMethod(method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class<?> beanType, String method, boolean cache) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType);
        answer.setMethod(method);
        answer.setCache(cache);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> setBody() {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetBodyDefinition answer = new SetBodyDefinition((Expression)clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setBody(Expression expression) {
        SetBodyDefinition answer = new SetBodyDefinition(expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public <Result> Type setBody(final Supplier<Result> supplier) {
        SetBodyDefinition answer = new SetBodyDefinition((Expression)new ExpressionAdapter(){

            public Result evaluate(Exchange exchange) {
                return supplier.get();
            }
        });
        this.addOutput(answer);
        return (Type)this;
    }

    public <Result> Type setBody(final Function<Exchange, Result> function) {
        SetBodyDefinition answer = new SetBodyDefinition((Expression)new ExpressionAdapter(){

            public Result evaluate(Exchange exchange) {
                return function.apply(exchange);
            }
        });
        this.addOutput(answer);
        return (Type)this;
    }

    public Type transform(Expression expression) {
        TransformDefinition answer = new TransformDefinition(expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> transform() {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        TransformDefinition answer = new TransformDefinition((Expression)clause);
        this.addOutput(answer);
        return clause;
    }

    public Type script(Expression expression) {
        ScriptDefinition answer = new ScriptDefinition(expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> script() {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        ScriptDefinition answer = new ScriptDefinition((Expression)clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setFaultBody(Expression expression) {
        SetFaultBodyDefinition answer = new SetFaultBodyDefinition(expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> setHeader(String name) {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetHeaderDefinition answer = new SetHeaderDefinition(name, clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setHeader(String name, Expression expression) {
        SetHeaderDefinition answer = new SetHeaderDefinition(name, expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type setHeader(String name, final Supplier<Object> supplier) {
        SetHeaderDefinition answer = new SetHeaderDefinition(name, (Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return supplier.get();
            }
        });
        this.addOutput(answer);
        return (Type)this;
    }

    public Type setProperty(String name, Expression expression) {
        SetPropertyDefinition answer = new SetPropertyDefinition(name, expression);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorDefinition<Type>> setProperty(String name) {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetPropertyDefinition answer = new SetPropertyDefinition(name, clause);
        this.addOutput(answer);
        return clause;
    }

    public Type removeHeader(String name) {
        RemoveHeaderDefinition answer = new RemoveHeaderDefinition(name);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type removeHeaders(String pattern) {
        RemoveHeadersDefinition answer = new RemoveHeadersDefinition(pattern);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type removeHeaders(String pattern, String ... excludePatterns) {
        RemoveHeadersDefinition answer = new RemoveHeadersDefinition(pattern, excludePatterns);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type removeProperty(String name) {
        RemovePropertyDefinition answer = new RemovePropertyDefinition(name);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type removeProperties(String pattern) {
        RemovePropertiesDefinition answer = new RemovePropertiesDefinition(pattern);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type removeProperties(String pattern, String ... excludePatterns) {
        RemovePropertiesDefinition answer = new RemovePropertiesDefinition(pattern, excludePatterns);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type convertBodyTo(Class<?> type) {
        this.addOutput(new ConvertBodyDefinition(type));
        return (Type)this;
    }

    public Type convertBodyTo(Class<?> type, String charset) {
        this.addOutput(new ConvertBodyDefinition(type, charset));
        return (Type)this;
    }

    public Type sort(Expression expression) {
        return this.sort(expression, null);
    }

    public <T> Type sort(Expression expression, Comparator<T> comparator) {
        this.addOutput(new SortDefinition<T>(expression, comparator));
        return (Type)this;
    }

    public <T> ExpressionClause<SortDefinition<T>> sort() {
        SortDefinition answer = new SortDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public ClaimCheckDefinition claimCheck() {
        ClaimCheckDefinition answer = new ClaimCheckDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type claimCheck(ClaimCheckOperation operation) {
        ClaimCheckDefinition answer = new ClaimCheckDefinition();
        answer.setOperation(operation);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type claimCheck(ClaimCheckOperation operation, String key) {
        return this.claimCheck(operation, key, null);
    }

    public Type claimCheck(ClaimCheckOperation operation, String key, String filter) {
        ClaimCheckDefinition answer = new ClaimCheckDefinition();
        answer.setOperation(operation);
        answer.setKey(key);
        answer.setFilter(filter);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type enrich(@AsEndpointUri String resourceUri) {
        return this.enrich(resourceUri, null);
    }

    public Type enrich(@AsEndpointUri String resourceUri, AggregationStrategy aggregationStrategy) {
        return this.enrich(resourceUri, aggregationStrategy, false);
    }

    public EnrichClause<ProcessorDefinition<Type>> enrichWith(@AsEndpointUri String resourceUri) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.enrich(resourceUri, clause);
        return clause;
    }

    public EnrichClause<ProcessorDefinition<Type>> enrichWith(@AsEndpointUri String resourceUri, boolean aggregateOnException) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.enrich(resourceUri, clause, aggregateOnException, false);
        return clause;
    }

    public EnrichClause<ProcessorDefinition<Type>> enrichWith(@AsEndpointUri String resourceUri, boolean aggregateOnException, boolean shareUnitOfWork) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.enrich(resourceUri, clause, aggregateOnException, shareUnitOfWork);
        return clause;
    }

    public Type enrich(@AsEndpointUri String resourceUri, AggregationStrategy aggregationStrategy, boolean aggregateOnException) {
        return this.enrich(resourceUri, aggregationStrategy, aggregateOnException, false);
    }

    public Type enrich(@AsEndpointUri String resourceUri, AggregationStrategy aggregationStrategy, boolean aggregateOnException, boolean shareUnitOfWork) {
        EnrichDefinition answer = new EnrichDefinition();
        answer.setExpression(new ConstantExpression(resourceUri));
        answer.setAggregationStrategy(aggregationStrategy);
        answer.setAggregateOnException(aggregateOnException);
        answer.setShareUnitOfWork(shareUnitOfWork);
        this.addOutput(answer);
        return (Type)this;
    }

    @AsEndpointUri
    public ExpressionClause<EnrichDefinition> enrich() {
        EnrichDefinition answer = new EnrichDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri) {
        return this.pollEnrich(resourceUri, null);
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, AggregationStrategy aggregationStrategy) {
        return this.pollEnrich(resourceUri, -1L, aggregationStrategy);
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, long timeout, AggregationStrategy aggregationStrategy) {
        return this.pollEnrich(resourceUri, timeout, aggregationStrategy, false);
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, long timeout, String aggregationStrategyRef) {
        return this.pollEnrich(resourceUri, timeout, aggregationStrategyRef, false);
    }

    public EnrichClause<ProcessorDefinition<Type>> pollEnrichWith(@AsEndpointUri String resourceUri) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.pollEnrich(resourceUri, -1L, clause, false);
        return clause;
    }

    public EnrichClause<ProcessorDefinition<Type>> pollEnrichWith(@AsEndpointUri String resourceUri, long timeout) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.pollEnrich(resourceUri, timeout, clause, false);
        return clause;
    }

    public EnrichClause<ProcessorDefinition<Type>> pollEnrichWith(@AsEndpointUri String resourceUri, long timeout, boolean aggregateOnException) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.pollEnrich(resourceUri, timeout, clause, aggregateOnException);
        return clause;
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, long timeout, AggregationStrategy aggregationStrategy, boolean aggregateOnException) {
        PollEnrichDefinition pollEnrich = new PollEnrichDefinition();
        pollEnrich.setExpression(new ConstantExpression(resourceUri));
        pollEnrich.setTimeout(timeout);
        pollEnrich.setAggregationStrategy(aggregationStrategy);
        pollEnrich.setAggregateOnException(aggregateOnException);
        this.addOutput(pollEnrich);
        return (Type)this;
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, long timeout, String aggregationStrategyRef, boolean aggregateOnException) {
        PollEnrichDefinition pollEnrich = new PollEnrichDefinition();
        pollEnrich.setExpression(new ConstantExpression(resourceUri));
        pollEnrich.setTimeout(timeout);
        pollEnrich.setAggregationStrategyRef(aggregationStrategyRef);
        pollEnrich.setAggregateOnException(aggregateOnException);
        this.addOutput(pollEnrich);
        return (Type)this;
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, long timeout) {
        return this.pollEnrich(resourceUri, timeout, (String)null);
    }

    public Type pollEnrich(@AsEndpointUri Expression expression, long timeout, String aggregationStrategyRef, boolean aggregateOnException) {
        PollEnrichDefinition pollEnrich = new PollEnrichDefinition();
        pollEnrich.setExpression(new ExpressionDefinition(expression));
        pollEnrich.setTimeout(timeout);
        pollEnrich.setAggregationStrategyRef(aggregationStrategyRef);
        pollEnrich.setAggregateOnException(aggregateOnException);
        this.addOutput(pollEnrich);
        return (Type)this;
    }

    @AsEndpointUri
    public ExpressionClause<PollEnrichDefinition> pollEnrich() {
        PollEnrichDefinition answer = new PollEnrichDefinition();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public OnCompletionDefinition onCompletion() {
        OnCompletionDefinition answer = new OnCompletionDefinition();
        answer.removeAllOnCompletionDefinition(this);
        this.popBlock();
        this.addOutput(answer);
        this.pushBlock(answer);
        return answer;
    }

    public DataFormatClause<ProcessorDefinition<Type>> unmarshal() {
        return new DataFormatClause<ProcessorDefinition<Type>>(this, DataFormatClause.Operation.Unmarshal);
    }

    public Type unmarshal(DataFormatDefinition dataFormatType) {
        this.addOutput(new UnmarshalDefinition(dataFormatType));
        return (Type)this;
    }

    public Type unmarshal(DataFormat dataFormat) {
        return this.unmarshal(new DataFormatDefinition(dataFormat));
    }

    public Type unmarshal(String dataTypeRef) {
        return this.unmarshal(new CustomDataFormat(dataTypeRef));
    }

    public DataFormatClause<ProcessorDefinition<Type>> marshal() {
        return new DataFormatClause<ProcessorDefinition<Type>>(this, DataFormatClause.Operation.Marshal);
    }

    public Type marshal(DataFormatDefinition dataFormatType) {
        this.addOutput(new MarshalDefinition(dataFormatType));
        return (Type)this;
    }

    public Type marshal(DataFormat dataFormat) {
        return this.marshal(new DataFormatDefinition(dataFormat));
    }

    public Type marshal(String dataTypeRef) {
        this.addOutput(new MarshalDefinition(new CustomDataFormat(dataTypeRef)));
        return (Type)this;
    }

    public Type inheritErrorHandler(boolean inheritErrorHandler) {
        int size = this.getOutputs().size();
        if (size == 0) {
            this.setInheritErrorHandler(inheritErrorHandler);
        } else {
            ProcessorDefinition<?> output = this.getOutputs().get(size - 1);
            if (output != null) {
                output.setInheritErrorHandler(inheritErrorHandler);
            }
        }
        return (Type)this;
    }

    public ProcessorDefinition<?> getParent() {
        return this.parent;
    }

    public void setParent(ProcessorDefinition<?> parent) {
        this.parent = parent;
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void addInterceptStrategy(InterceptStrategy strategy) {
        this.interceptStrategies.add(strategy);
    }

    public Boolean isInheritErrorHandler() {
        return this.inheritErrorHandler;
    }

    public void setInheritErrorHandler(Boolean inheritErrorHandler) {
        this.inheritErrorHandler = inheritErrorHandler;
    }

    @Override
    public Map<QName, Object> getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    public void setOtherAttributes(Map<QName, Object> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public String getLabel() {
        return "";
    }
}

