/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.model.NoOutputExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,transformation")
@XmlRootElement(name="pollEnrich")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PollEnrichDefinition
extends NoOutputExpressionNode {
    @XmlAttribute
    @Metadata(defaultValue="-1")
    private Long timeout;
    @XmlAttribute(name="strategyRef")
    private String aggregationStrategyRef;
    @XmlAttribute(name="strategyMethodName")
    private String aggregationStrategyMethodName;
    @XmlAttribute(name="strategyMethodAllowNull")
    private Boolean aggregationStrategyMethodAllowNull;
    @XmlAttribute
    private Boolean aggregateOnException;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlAttribute
    private Integer cacheSize;
    @XmlAttribute
    private Boolean ignoreInvalidEndpoint;

    public PollEnrichDefinition() {
    }

    public PollEnrichDefinition(AggregationStrategy aggregationStrategy, long timeout) {
        this.aggregationStrategy = aggregationStrategy;
        this.timeout = timeout;
    }

    public String toString() {
        return "PollEnrich[" + this.getExpression() + "]";
    }

    public String getShortName() {
        return "pollEnrich";
    }

    @Override
    public String getLabel() {
        return "pollEnrich[" + this.getExpression() + "]";
    }

    public PollEnrichDefinition timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public PollEnrichDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public PollEnrichDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setAggregationStrategyRef(aggregationStrategyRef);
        return this;
    }

    public PollEnrichDefinition aggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.setAggregationStrategyMethodName(aggregationStrategyMethodName);
        return this;
    }

    public PollEnrichDefinition aggregationStrategyMethodAllowNull(boolean aggregationStrategyMethodAllowNull) {
        this.setAggregationStrategyMethodAllowNull(aggregationStrategyMethodAllowNull);
        return this;
    }

    public PollEnrichDefinition aggregateOnException(boolean aggregateOnException) {
        this.setAggregateOnException(aggregateOnException);
        return this;
    }

    public PollEnrichDefinition cacheSize(int cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    public PollEnrichDefinition ignoreInvalidEndpoint() {
        this.setIgnoreInvalidEndpoint(true);
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getAggregationStrategyRef() {
        return this.aggregationStrategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.aggregationStrategyRef = aggregationStrategyRef;
    }

    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }

    public Boolean getAggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull;
    }

    public void setAggregationStrategyMethodAllowNull(Boolean aggregationStrategyMethodAllowNull) {
        this.aggregationStrategyMethodAllowNull = aggregationStrategyMethodAllowNull;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public Boolean getAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(Boolean aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Boolean getIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(Boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }
}

