/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.model.EndpointRequiredDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;

@Metadata(label="eip,endpoint,routing")
@XmlRootElement(name="from")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FromDefinition
extends OptionalIdentifiedDefinition<FromDefinition>
implements EndpointRequiredDefinition {
    @XmlAttribute
    @Metadata(required=true)
    private String uri;
    @XmlTransient
    private Endpoint endpoint;

    public FromDefinition() {
    }

    public FromDefinition(String uri) {
        this.setUri(uri);
    }

    public FromDefinition(Endpoint endpoint) {
        this.setEndpoint(endpoint);
    }

    public String toString() {
        return "From[" + this.getLabel() + "]";
    }

    public String getShortName() {
        return "from";
    }

    public String getLabel() {
        return FromDefinition.description(this.getUri(), this.getEndpoint());
    }

    public Endpoint resolveEndpoint(RouteContext context) {
        if (this.endpoint == null) {
            return context.resolveEndpoint(this.getUri());
        }
        return this.endpoint;
    }

    @Override
    public String getEndpointUri() {
        return this.getUri();
    }

    public String getUri() {
        if (this.uri != null) {
            return this.uri;
        }
        if (this.endpoint != null) {
            return this.endpoint.getEndpointUri();
        }
        return null;
    }

    public void setUri(String uri) {
        this.clear();
        this.uri = uri;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        this.uri = null;
        if (endpoint != null) {
            this.uri = endpoint.getEndpointUri();
        }
    }

    protected static String description(String uri, Endpoint endpoint) {
        if (endpoint != null) {
            return endpoint.getEndpointUri();
        }
        if (uri != null) {
            return uri;
        }
        return "no uri or ref supplied!";
    }

    protected void clear() {
        this.endpoint = null;
        this.uri = null;
    }
}

