/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.SimpleBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.model.language.XPathExpression;

public final class ExpressionNodeHelper {
    private ExpressionNodeHelper() {
    }

    public static ExpressionDefinition toExpressionDefinition(Expression expression) {
        if (expression instanceof SimpleBuilder) {
            SimpleBuilder builder = (SimpleBuilder)expression;
            SimpleExpression answer = new SimpleExpression(builder);
            answer.setExpression(builder.getText());
            answer.setResultType(builder.getResultType());
            return answer;
        }
        if (expression instanceof XPathBuilder) {
            XPathBuilder builder = (XPathBuilder)expression;
            XPathExpression answer = new XPathExpression(builder);
            answer.setExpression(builder.getText());
            answer.setResultType(builder.getResultType());
            return answer;
        }
        if (expression instanceof ValueBuilder) {
            ValueBuilder builder = (ValueBuilder)expression;
            expression = builder.getExpression();
        }
        if (expression instanceof ExpressionDefinition) {
            return (ExpressionDefinition)expression;
        }
        return new ExpressionDefinition(expression);
    }

    public static ExpressionDefinition toExpressionDefinition(Predicate predicate) {
        ValueBuilder builder;
        Expression expression;
        if (predicate instanceof SimpleBuilder) {
            SimpleBuilder builder2 = (SimpleBuilder)predicate;
            SimpleExpression answer = new SimpleExpression(builder2);
            answer.setExpression(builder2.getText());
            return answer;
        }
        if (predicate instanceof XPathBuilder) {
            XPathBuilder builder3 = (XPathBuilder)predicate;
            XPathExpression answer = new XPathExpression(builder3);
            answer.setExpression(builder3.getText());
            return answer;
        }
        if (predicate instanceof ValueBuilder && (expression = (builder = (ValueBuilder)predicate).getExpression()) instanceof Predicate) {
            predicate = (Predicate)expression;
        }
        if (predicate instanceof ExpressionDefinition) {
            return (ExpressionDefinition)predicate;
        }
        return new ExpressionDefinition(predicate);
    }
}

