/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OtherAttributesAware;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="dataformat,transformation")
@XmlType(name="dataFormat")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataFormatDefinition
extends IdentifiedType
implements OtherAttributesAware {
    @XmlTransient
    private DataFormat dataFormat;
    @XmlTransient
    private String dataFormatName;
    @XmlAnyAttribute
    private Map<QName, Object> otherAttributes;
    @XmlAttribute
    private Boolean contentTypeHeader;

    public DataFormatDefinition() {
    }

    public DataFormatDefinition(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    protected DataFormatDefinition(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public static DataFormat getDataFormat(RouteContext routeContext, DataFormatDefinition type, String ref) {
        if (type == null) {
            ObjectHelper.notNull((Object)ref, (String)"ref or type");
            type = ((ModelCamelContext)routeContext.getCamelContext().adapt(ModelCamelContext.class)).resolveDataFormatDefinition(ref);
            if (type != null) {
                return type.getDataFormat(routeContext);
            }
            DataFormat dataFormat = routeContext.getCamelContext().resolveDataFormat(ref);
            if (dataFormat == null) {
                throw new IllegalArgumentException("Cannot find data format in registry with ref: " + ref);
            }
            return dataFormat;
        }
        return type.getDataFormat(routeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataFormat getDataFormat(RouteContext routeContext) {
        block9: {
            if (this.dataFormat == null) {
                Runnable propertyPlaceholdersChangeReverter = ProcessorDefinitionHelper.createPropertyPlaceholdersChangeReverter();
                try {
                    ProcessorDefinitionHelper.resolvePropertyPlaceholders(routeContext.getCamelContext(), this);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error resolving property placeholders on data format: " + this, e);
                }
                try {
                    this.dataFormat = this.createDataFormat(routeContext);
                    if (this.dataFormat != null) {
                        boolean contentTypeHeader = this.contentTypeHeader == null || this.contentTypeHeader != false;
                        try {
                            this.setProperty(routeContext.getCamelContext(), this.dataFormat, "contentTypeHeader", contentTypeHeader);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.configureDataFormat(this.dataFormat, routeContext.getCamelContext());
                        break block9;
                    }
                    throw new IllegalArgumentException("Data format '" + (this.dataFormatName != null ? this.dataFormatName : "<null>") + "' could not be created. Ensure that the data format is valid and the associated Camel component is present on the classpath");
                }
                finally {
                    propertyPlaceholdersChangeReverter.run();
                }
            }
        }
        return this.dataFormat;
    }

    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.getDataFormatName() != null) {
            return routeContext.getCamelContext().createDataFormat(this.getDataFormatName());
        }
        return null;
    }

    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
    }

    protected void setProperty(CamelContext camelContext, Object bean, String name, Object value) {
        try {
            String ref;
            String string = ref = value instanceof String ? value.toString() : null;
            if (EndpointHelper.isReferenceParameter((String)ref) && camelContext != null) {
                IntrospectionSupport.setProperty((CamelContext)camelContext, (TypeConverter)camelContext.getTypeConverter(), (Object)bean, (String)name, null, (String)ref, (boolean)true);
            } else {
                IntrospectionSupport.setProperty((Object)bean, (String)name, (Object)value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property: " + name + " on: " + bean + ". Reason: " + e, e);
        }
    }

    public String getDataFormatName() {
        return this.dataFormatName;
    }

    public void setDataFormatName(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public Map<QName, Object> getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    public void setOtherAttributes(Map<QName, Object> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public Boolean getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(Boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public String getShortName() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith("DataFormat")) {
            name = name.substring(0, name.indexOf("DataFormat"));
        }
        return name;
    }
}

