/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.FileWatcherReloadStrategy;
import org.apache.camel.main.MainDurationEventNotifier;
import org.apache.camel.main.MainLifecycleStrategy;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainRegistry;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MainSupport
extends ServiceSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(MainSupport.class);
    protected static final int UNINITIALIZED_EXIT_CODE = Integer.MIN_VALUE;
    protected static final int DEFAULT_EXIT_CODE = 0;
    protected final List<MainListener> listeners = new ArrayList<MainListener>();
    protected final List<Option> options = new ArrayList<Option>();
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected final AtomicBoolean completed = new AtomicBoolean(false);
    protected final AtomicInteger exitCode = new AtomicInteger(Integer.MIN_VALUE);
    protected long duration = -1L;
    protected long durationIdle = -1L;
    protected int durationMaxMessages;
    protected TimeUnit timeUnit = TimeUnit.SECONDS;
    protected boolean trace;
    protected CamelContext camelContext;
    protected List<RouteBuilder> routeBuilders = new ArrayList<RouteBuilder>();
    protected String routeBuilderClasses;
    protected List<Object> configurations = new ArrayList<Object>();
    protected String configurationClasses;
    protected String fileWatchDirectory;
    protected boolean fileWatchDirectoryRecursively;
    protected ProducerTemplate camelTemplate;
    protected boolean hangupInterceptorEnabled = true;
    protected int durationHitExitCode = 0;
    protected ReloadStrategy reloadStrategy;
    protected String propertyPlaceholderLocations;
    protected boolean autoConfigurationEnabled = true;
    protected Properties initialProperties;
    protected Properties overrideProperties;

    protected MainSupport(Class ... configurationClasses) {
        this();
        this.addConfigurationClass(configurationClasses);
    }

    protected MainSupport() {
        this.addOption(new Option("h", "help", "Displays the help screen"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                MainSupport.this.showOptions();
                MainSupport.this.completed();
            }
        });
        this.addOption(new ParameterOption("r", "routers", "Sets the router builder classes which will be loaded while starting the camel context", "routerBuilderClasses"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setRouteBuilderClasses(parameter);
            }
        });
        this.addOption(new ParameterOption("d", "duration", "Sets the time duration (seconds) that the application will run for before terminating.", "duration"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (parameter.endsWith("s") || parameter.endsWith("S")) {
                    parameter = parameter.substring(0, parameter.length() - 1);
                }
                MainSupport.this.setDuration(Integer.parseInt(parameter));
            }
        });
        this.addOption(new ParameterOption("dm", "durationMaxMessages", "Sets the duration of maximum number of messages that the application will process before terminating.", "durationMaxMessages"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setDurationMaxMessages(Integer.parseInt(parameter));
            }
        });
        this.addOption(new ParameterOption("di", "durationIdle", "Sets the idle time duration (seconds) duration that the application can be idle before terminating.", "durationIdle"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                if (parameter.endsWith("s") || parameter.endsWith("S")) {
                    parameter = parameter.substring(0, parameter.length() - 1);
                }
                MainSupport.this.setDurationIdle(Integer.parseInt(parameter));
            }
        });
        this.addOption(new Option("t", "trace", "Enables tracing"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                MainSupport.this.enableTrace();
            }
        });
        this.addOption(new ParameterOption("e", "exitcode", "Sets the exit code if duration was hit", "exitcode"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setDurationHitExitCode(Integer.parseInt(parameter));
            }
        });
        this.addOption(new ParameterOption("watch", "fileWatch", "Sets a directory to watch for file changes to trigger reloading routes on-the-fly", "fileWatch"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setFileWatchDirectory(parameter);
            }
        });
        this.addOption(new ParameterOption("pl", "propertiesLocation", "Sets location(s) to load properties, such as from classpath or file system.", "propertiesLocation"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setPropertyPlaceholderLocations(parameter);
            }
        });
    }

    public void run() throws Exception {
        if (!this.completed.get()) {
            this.internalBeforeStart();
            this.beforeStart();
            this.start();
            try {
                this.afterStart();
                this.waitUntilCompleted();
                this.internalBeforeStop();
                this.beforeStop();
                this.stop();
                this.afterStop();
            }
            catch (Exception e) {
                LOG.error("Failed: {}", (Object)e, (Object)e);
            }
        }
    }

    public void disableHangupSupport() {
        this.hangupInterceptorEnabled = false;
    }

    public void enableHangupSupport() {
        this.hangupInterceptorEnabled = true;
    }

    public void addMainListener(MainListener listener) {
        this.listeners.add(listener);
    }

    public void removeMainListener(MainListener listener) {
        this.listeners.remove(listener);
    }

    protected void beforeStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStart(this);
        }
    }

    protected void afterStart() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStart(this);
        }
    }

    private void internalBeforeStart() {
        if (this.hangupInterceptorEnabled) {
            String threadName = ThreadHelper.resolveThreadName(null, (String)"CamelHangupInterceptor");
            HangupInterceptor task = new HangupInterceptor(this);
            task.setName(threadName);
            Runtime.getRuntime().addShutdownHook(task);
        }
    }

    protected void beforeStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.beforeStop(this);
        }
    }

    protected void afterStop() throws Exception {
        for (MainListener listener : this.listeners) {
            listener.afterStop(this);
        }
    }

    private void internalBeforeStop() {
        try {
            if (this.camelTemplate != null) {
                ServiceHelper.stopService((Object)this.camelTemplate);
                this.camelTemplate = null;
            }
        }
        catch (Exception e) {
            LOG.debug("Error stopping camelTemplate due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
        }
    }

    public void completed() {
        this.completed.set(true);
        this.exitCode.compareAndSet(Integer.MIN_VALUE, 0);
        this.latch.countDown();
    }

    public void showOptions() {
        this.showOptionsHeader();
        for (Option option : this.options) {
            System.out.println(option.getInformation());
        }
    }

    public void parseArguments(String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        boolean valid = true;
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            boolean handled = false;
            for (Option option : this.options) {
                if (!option.processOption(arg, args)) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            System.out.println("Unknown option: " + arg);
            System.out.println();
            valid = false;
            break;
        }
        if (!valid) {
            this.showOptions();
            this.completed();
        }
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDurationIdle() {
        return this.durationIdle;
    }

    public void setDurationIdle(long durationIdle) {
        this.durationIdle = durationIdle;
    }

    public int getDurationMaxMessages() {
        return this.durationMaxMessages;
    }

    public void setDurationMaxMessages(int durationMaxMessages) {
        this.durationMaxMessages = durationMaxMessages;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setDurationHitExitCode(int durationHitExitCode) {
        this.durationHitExitCode = durationHitExitCode;
    }

    public int getDurationHitExitCode() {
        return this.durationHitExitCode;
    }

    public int getExitCode() {
        return this.exitCode.get();
    }

    public String getConfigurationClasses() {
        return this.configurationClasses;
    }

    public void setConfigurationClasses(String configurations) {
        this.configurationClasses = configurations;
    }

    public void addConfigurationClass(Class ... configuration) {
        String existing = this.configurationClasses;
        if (existing == null) {
            existing = "";
        }
        if (configuration != null) {
            for (Class clazz : configuration) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setConfigurationClasses(existing);
    }

    public void addConfiguration(Object configuration) {
        this.configurations.add(configuration);
    }

    public String getRouteBuilderClasses() {
        return this.routeBuilderClasses;
    }

    public void setRouteBuilderClasses(String builders) {
        this.routeBuilderClasses = builders;
    }

    public String getFileWatchDirectory() {
        return this.fileWatchDirectory;
    }

    public void setFileWatchDirectory(String fileWatchDirectory) {
        this.fileWatchDirectory = fileWatchDirectory;
    }

    public boolean isFileWatchDirectoryRecursively() {
        return this.fileWatchDirectoryRecursively;
    }

    public void setFileWatchDirectoryRecursively(boolean fileWatchDirectoryRecursively) {
        this.fileWatchDirectoryRecursively = fileWatchDirectoryRecursively;
    }

    public ReloadStrategy getReloadStrategy() {
        return this.reloadStrategy;
    }

    public void setReloadStrategy(ReloadStrategy reloadStrategy) {
        this.reloadStrategy = reloadStrategy;
    }

    public String getPropertyPlaceholderLocations() {
        return this.propertyPlaceholderLocations;
    }

    public void setPropertyPlaceholderLocations(String location) {
        this.propertyPlaceholderLocations = location;
    }

    public boolean isAutoConfigurationEnabled() {
        return this.autoConfigurationEnabled;
    }

    public void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.autoConfigurationEnabled = autoConfigurationEnabled;
    }

    public Properties getInitialProperties() {
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void enableTrace() {
        this.trace = true;
    }

    protected void doStop() throws Exception {
        this.completed();
    }

    protected void doStart() throws Exception {
    }

    protected void waitUntilCompleted() {
        while (!this.completed.get()) {
            try {
                TimeUnit unit;
                if (this.duration > 0L) {
                    unit = this.getTimeUnit();
                    LOG.info("Waiting for: {} {}", (Object)this.duration, (Object)unit);
                    this.latch.await(this.duration, unit);
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.durationHitExitCode);
                    this.completed.set(true);
                    continue;
                }
                if (this.durationIdle > 0L) {
                    unit = this.getTimeUnit();
                    LOG.info("Waiting to be idle for: {} {}", (Object)this.duration, (Object)unit);
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.durationHitExitCode);
                    this.latch.await();
                    this.completed.set(true);
                    continue;
                }
                if (this.durationMaxMessages > 0) {
                    LOG.info("Waiting until: {} messages has been processed", (Object)this.durationMaxMessages);
                    this.exitCode.compareAndSet(Integer.MIN_VALUE, this.durationHitExitCode);
                    this.latch.await();
                    this.completed.set(true);
                    continue;
                }
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void run(String[] args) throws Exception {
        this.parseArguments(args);
        this.run();
        LOG.info("MainSupport exiting code: {}", (Object)this.getExitCode());
    }

    public void showOptionsHeader() {
        System.out.println("Apache Camel Runner takes the following options");
        System.out.println();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public List<RouteBuilder> getRouteBuilders() {
        return this.routeBuilders;
    }

    public void setRouteBuilders(List<RouteBuilder> routeBuilders) {
        this.routeBuilders = routeBuilders;
    }

    public List<Object> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<Object> configurations) {
        this.configurations = configurations;
    }

    public List<RouteDefinition> getRouteDefinitions() {
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        if (this.camelContext != null) {
            answer.addAll(((ModelCamelContext)this.camelContext.adapt(ModelCamelContext.class)).getRouteDefinitions());
        }
        return answer;
    }

    public ProducerTemplate getCamelTemplate() throws Exception {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.findOrCreateCamelTemplate();
        }
        return this.camelTemplate;
    }

    protected abstract ProducerTemplate findOrCreateCamelTemplate();

    protected abstract CamelContext createCamelContext();

    protected void initCamelContext() throws Exception {
        this.camelContext = this.createCamelContext();
        this.postProcessCamelContext(this.camelContext);
    }

    protected void loadRouteBuilders(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = camelContext.getBeanPostProcessor();
        for (RouteBuilder routeBuilder : this.getRouteBuilders()) {
            postProcessor.postProcessBeforeInitialization((Object)routeBuilder, routeBuilder.getClass().getName());
            postProcessor.postProcessAfterInitialization((Object)routeBuilder, routeBuilder.getClass().getName());
        }
        if (this.routeBuilderClasses != null) {
            String[] routeClasses;
            for (String routeClass : routeClasses = this.routeBuilderClasses.split(",")) {
                Class routeClazz = camelContext.getClassResolver().resolveClass(routeClass);
                Object builder = camelContext.getInjector().newInstance(routeClazz);
                if (builder instanceof RouteBuilder) {
                    this.getRouteBuilders().add((RouteBuilder)builder);
                    continue;
                }
                LOG.warn("Class {} is not a RouteBuilder class", (Object)routeClazz);
            }
        }
    }

    protected void loadConfigurations(CamelContext camelContext) throws Exception {
        CamelBeanPostProcessor postProcessor = camelContext.getBeanPostProcessor();
        for (Object object : this.getConfigurations()) {
            postProcessor.postProcessBeforeInitialization(object, object.getClass().getName());
            postProcessor.postProcessAfterInitialization(object, object.getClass().getName());
        }
        if (this.configurationClasses != null) {
            String[] configClasses;
            for (String configClass : configClasses = this.configurationClasses.split(",")) {
                Class configClazz = camelContext.getClassResolver().resolveClass(configClass);
                Object config = camelContext.getInjector().newInstance(configClazz);
                this.getConfigurations().add(config);
            }
        }
        for (Object object : this.getConfigurations()) {
            Method method = ReflectionHelper.findMethod(object.getClass(), (String)"configure", (Class[])new Class[0]);
            if (method == null) continue;
            this.log.info("Calling configure method on configuration class: {}", (Object)object.getClass().getName());
            ObjectHelper.invokeMethod((Method)method, (Object)object, (Object[])new Object[0]);
        }
    }

    protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        PropertiesComponent pc;
        if (this.propertyPlaceholderLocations != null) {
            pc = camelContext.getPropertiesComponent();
            pc.addLocation(this.propertyPlaceholderLocations);
            if (this.initialProperties != null) {
                pc.setInitialProperties(this.initialProperties);
            }
            if (this.overrideProperties != null) {
                pc.setOverrideProperties(this.overrideProperties);
            }
            LOG.info("Using properties from: {}", (Object)this.propertyPlaceholderLocations);
        } else {
            pc = camelContext.getPropertiesComponent();
            pc.addLocation("classpath:application.properties");
            pc.setIgnoreMissingLocation(true);
            if (this.initialProperties != null) {
                pc.setInitialProperties(this.initialProperties);
            }
            if (this.overrideProperties != null) {
                pc.setOverrideProperties(this.overrideProperties);
            }
            LOG.info("Using optional properties from classpath:application.properties");
        }
        if (this.trace) {
            camelContext.setTracing(Boolean.valueOf(true));
        }
        if (this.fileWatchDirectory != null) {
            FileWatcherReloadStrategy reload = new FileWatcherReloadStrategy(this.fileWatchDirectory, this.fileWatchDirectoryRecursively);
            camelContext.setReloadStrategy((ReloadStrategy)reload);
            camelContext.addService((Object)reload);
            Object managedObject = camelContext.getManagementStrategy().getManagementObjectStrategy().getManagedObjectForService(camelContext, (Service)reload);
            if (managedObject == null) {
                return;
            }
            if (camelContext.getManagementStrategy().isManaged(managedObject)) {
                LOG.trace("The service is already managed: {}", (Object)reload);
                return;
            }
            try {
                camelContext.getManagementStrategy().manageObject(managedObject);
            }
            catch (Exception e) {
                LOG.warn("Could not register service: " + (Object)((Object)reload) + " as Service MBean.", (Throwable)e);
            }
        }
        if (this.durationMaxMessages > 0 || this.durationIdle > 0L) {
            long seconds = this.timeUnit.toSeconds(this.durationIdle);
            MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.durationMaxMessages, seconds, this.completed, this.latch, true);
            ServiceHelper.startService((Object)((Object)notifier));
            camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
        }
        this.loadConfigurations(camelContext);
        if (this.autoConfigurationEnabled) {
            this.autoConfigurationFromRegistry(camelContext);
            this.autoConfigurationFromProperties(camelContext);
        }
        this.loadRouteBuilders(camelContext);
        for (RouteBuilder routeBuilder : this.routeBuilders) {
            camelContext.addRoutes((RoutesBuilder)routeBuilder);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new MainLifecycleStrategy(this.completed, this.latch));
        for (MainListener listener : this.listeners) {
            listener.configure(camelContext);
        }
    }

    protected void autoConfigurationFromProperties(CamelContext camelContext) throws Exception {
        Properties prop = camelContext.getPropertiesComponent().loadProperties();
        LinkedHashMap<Object, Map> properties = new LinkedHashMap<Object, Map>();
        for (String key : prop.stringPropertyNames()) {
            Map values;
            String option;
            String value;
            String name;
            int dot = key.indexOf(".", 16);
            if (key.startsWith("camel.component.") && dot > 0) {
                name = key.substring(16, dot);
                Component component = camelContext.getComponent(name);
                value = prop.getProperty(key);
                option = key.substring(dot + 1);
                values = properties.getOrDefault(component, new LinkedHashMap());
                values.put(option, value);
                properties.put(component, values);
            }
            dot = key.indexOf(".", 17);
            if (key.startsWith("camel.dataformat.") && dot > 0) {
                name = key.substring(17, dot);
                DataFormat dataformat = camelContext.resolveDataFormat(name);
                value = prop.getProperty(key);
                option = key.substring(dot + 1);
                values = properties.getOrDefault(dataformat, new LinkedHashMap());
                values.put(option, value);
                properties.put(dataformat, values);
            }
            dot = key.indexOf(".", 15);
            if (!key.startsWith("camel.language.") || dot <= 0) continue;
            name = key.substring(15, dot);
            Language language = camelContext.resolveLanguage(name);
            value = prop.getProperty(key);
            option = key.substring(dot + 1);
            values = properties.getOrDefault(language, new LinkedHashMap());
            values.put(option, value);
            properties.put(language, values);
        }
        if (!properties.isEmpty()) {
            long total = properties.values().stream().mapToLong(Map::size).sum();
            LOG.info("Auto configuring {} components/dataformat/languages from loaded properties: {}", (Object)properties.size(), (Object)total);
        }
        for (String obj : properties.keySet()) {
            Map values = (Map)properties.get(obj);
            MainSupport.setCamelProperties(camelContext, obj, values, true);
        }
    }

    protected void autoConfigurationFromRegistry(final CamelContext camelContext) throws Exception {
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onComponentAdd(String name, Component component) {
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                IntrospectionSupport.getProperties((Object)component, properties, null);
                properties.forEach((k, v) -> {
                    Set lookup;
                    Class type = this.getGetterType(component, (String)k);
                    if (this.isComplexType(type) && (lookup = this.findExplicitBindingByType(camelContext, type)).size() == 1) {
                        v = lookup.iterator().next();
                        try {
                            LOG.info("Auto configuring option: {} on component: {} as one instance of type: {} registered in the Camel Registry", new Object[]{k, name, type.getName()});
                            IntrospectionSupport.setProperty((CamelContext)camelContext, (Object)component, (String)k, (Object)v);
                        }
                        catch (Exception e) {
                            LOG.warn("Cannot auto configure option: " + k + " on component: " + name + " due to " + e.getMessage());
                        }
                    }
                });
            }

            private Set findExplicitBindingByType(CamelContext camelContext2, Class type) {
                if (camelContext2.getRegistry() instanceof MainRegistry) {
                    return ((MainRegistry)camelContext2.getRegistry()).findBindingsByType(type);
                }
                return Collections.EMPTY_SET;
            }

            private boolean isComplexType(Class type) {
                return type != null && !type.isPrimitive() && !type.getName().startsWith("java");
            }

            private Class getGetterType(Component component, String key) {
                try {
                    Method getter = IntrospectionSupport.getPropertyGetter(component.getClass(), (String)key);
                    if (getter != null) {
                        return getter.getReturnType();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void addRouteBuilder(RouteBuilder routeBuilder) {
        this.getRouteBuilders().add(routeBuilder);
    }

    public void addRouteBuilder(Class ... routeBuilder) {
        String existing = this.routeBuilderClasses;
        if (existing == null) {
            existing = "";
        }
        if (routeBuilder != null) {
            for (Class clazz : routeBuilder) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setRouteBuilderClasses(existing);
    }

    private static boolean setCamelProperties(CamelContext context, Object target, Map<String, Object> properties, boolean failIfNotSet) throws Exception {
        org.apache.camel.util.ObjectHelper.notNull((Object)context, (String)"context");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        boolean rc = false;
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object value = entry.getValue();
            String stringValue = value != null ? value.toString() : null;
            boolean hit = false;
            if (EndpointHelper.isReferenceParameter((String)stringValue)) {
                hit = IntrospectionSupport.setProperty((CamelContext)context, (TypeConverter)context.getTypeConverter(), (Object)target, (String)name, null, (String)stringValue, (boolean)true);
            } else if (value != null) {
                try {
                    hit = IntrospectionSupport.setProperty((CamelContext)context, (TypeConverter)context.getTypeConverter(), (Object)target, (String)name, (Object)value);
                }
                catch (IllegalArgumentException var12) {
                    hit = IntrospectionSupport.setProperty((CamelContext)context, (TypeConverter)context.getTypeConverter(), (Object)target, (String)name, null, (String)stringValue, (boolean)true);
                }
            }
            if (hit) {
                it.remove();
                rc = true;
                continue;
            }
            if (!failIfNotSet) continue;
            throw new IllegalArgumentException("Cannot configure option [" + name + "] with value [" + stringValue + "] as the bean class [" + org.apache.camel.util.ObjectHelper.classCanonicalName((Object)target) + "] has no suitable setter method, or not possible to lookup a bean with the id [" + stringValue + "] in Camel registry");
        }
        return rc;
    }

    public abstract class ParameterOption
    extends Option {
        private String parameterName;

        protected ParameterOption(String abbreviation, String fullName, String description, String parameterName) {
            super(abbreviation, fullName, description);
            this.parameterName = parameterName;
        }

        @Override
        protected void doProcess(String arg, LinkedList<String> remainingArgs) {
            if (remainingArgs.isEmpty()) {
                System.err.println("Expected fileName for ");
                MainSupport.this.showOptions();
                MainSupport.this.completed();
            } else {
                String parameter = remainingArgs.removeFirst();
                this.doProcess(arg, parameter, remainingArgs);
            }
        }

        @Override
        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " <" + this.parameterName + "> = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, String var2, LinkedList<String> var3);
    }

    public abstract class Option {
        private String abbreviation;
        private String fullName;
        private String description;

        protected Option(String abbreviation, String fullName, String description) {
            this.abbreviation = "-" + abbreviation;
            this.fullName = "-" + fullName;
            this.description = description;
        }

        public boolean processOption(String arg, LinkedList<String> remainingArgs) {
            if (arg.equalsIgnoreCase(this.abbreviation) || this.fullName.startsWith(arg)) {
                this.doProcess(arg, remainingArgs);
                return true;
            }
            return false;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, LinkedList<String> var2);
    }

    private static final class HangupInterceptor
    extends Thread {
        Logger log = LoggerFactory.getLogger(this.getClass());
        final MainSupport mainInstance;

        HangupInterceptor(MainSupport main) {
            this.mainInstance = main;
        }

        @Override
        public void run() {
            this.log.info("Received hang up - stopping the main instance.");
            try {
                this.mainInstance.stop();
            }
            catch (Exception ex) {
                this.log.warn("Error during stopping the main instance.", (Throwable)ex);
            }
        }
    }
}

