/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xpath;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.LanguageSupport;

@Language(value="xpath")
public class XPathLanguage
extends LanguageSupport {
    private QName resultType;
    private XPathFactory xpathFactory;
    private Boolean useSaxon;
    private String objectModelUri;
    private Boolean threadSafety;

    public Predicate createPredicate(String expression) {
        expression = this.loadResource(expression);
        XPathBuilder builder = XPathBuilder.xpath(expression);
        this.configureBuilder(builder);
        return builder;
    }

    public Expression createExpression(String expression) {
        expression = this.loadResource(expression);
        XPathBuilder builder = XPathBuilder.xpath(expression);
        this.configureBuilder(builder);
        return builder;
    }

    public QName getResultType() {
        return this.resultType;
    }

    public void setResultType(QName resultType) {
        this.resultType = resultType;
    }

    public XPathFactory getXpathFactory() {
        return this.xpathFactory;
    }

    public void setXpathFactory(XPathFactory xpathFactory) {
        this.xpathFactory = xpathFactory;
    }

    public void setUseSaxon(Boolean useSaxon) {
        this.useSaxon = useSaxon;
    }

    public Boolean getUseSaxon() {
        return this.useSaxon;
    }

    public Boolean isUseSaxon() {
        return this.useSaxon != null && this.useSaxon != false;
    }

    public String getObjectModelUri() {
        return this.objectModelUri;
    }

    public void setObjectModelUri(String objectModelUri) {
        this.objectModelUri = objectModelUri;
    }

    public Boolean getThreadSafety() {
        return this.threadSafety;
    }

    public void setThreadSafety(Boolean threadSafety) {
        this.threadSafety = threadSafety;
    }

    protected void configureBuilder(XPathBuilder builder) {
        if (this.threadSafety != null) {
            builder.setThreadSafety(this.threadSafety);
        }
        if (this.resultType != null) {
            builder.setResultQName(this.resultType);
        }
        if (this.isUseSaxon().booleanValue()) {
            builder.enableSaxon();
        } else {
            if (this.xpathFactory != null) {
                builder.setXPathFactory(this.xpathFactory);
            }
            if (this.objectModelUri != null) {
                builder.setObjectModelUri(this.objectModelUri);
            }
        }
    }

    public boolean isSingleton() {
        return false;
    }
}

