/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.types.LogicalOperatorType;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.util.ObjectHelper;

public class LogicalExpression
extends BaseSimpleNode {
    private LogicalOperatorType operator;
    private SimpleNode left;
    private SimpleNode right;

    public LogicalExpression(SimpleToken token) {
        super(token);
        this.operator = LogicalOperatorType.asOperator(token.getText());
    }

    @Override
    public String toString() {
        return this.left + " " + this.token.getText() + " " + this.right;
    }

    public boolean acceptLeftNode(SimpleNode lef) {
        this.left = lef;
        return true;
    }

    public boolean acceptRightNode(SimpleNode right) {
        this.right = right;
        return true;
    }

    public LogicalOperatorType getOperator() {
        return this.operator;
    }

    @Override
    public Expression createExpression(String expression) {
        ObjectHelper.notNull((Object)this.left, (String)"left node", (Object)this);
        ObjectHelper.notNull((Object)this.right, (String)"right node", (Object)this);
        Expression leftExp = this.left.createExpression(expression);
        Expression rightExp = this.right.createExpression(expression);
        if (this.operator == LogicalOperatorType.AND) {
            return this.createAndExpression(leftExp, rightExp);
        }
        if (this.operator == LogicalOperatorType.OR) {
            return this.createOrExpression(leftExp, rightExp);
        }
        throw new SimpleParserException("Unknown logical operator " + (Object)((Object)this.operator), this.token.getIndex());
    }

    private Expression createAndExpression(final Expression leftExp, final Expression rightExp) {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Predicate predicate = ExpressionToPredicateAdapter.toPredicate((Expression)leftExp);
                predicate = PredicateBuilder.and(predicate, ExpressionToPredicateAdapter.toPredicate((Expression)rightExp));
                boolean answer = predicate.matches(exchange);
                return (T)exchange.getContext().getTypeConverter().convertTo(type, (Object)answer);
            }

            public String toString() {
                return LogicalExpression.this.left + " " + LogicalExpression.this.token.getText() + " " + LogicalExpression.this.right;
            }
        };
    }

    private Expression createOrExpression(final Expression leftExp, final Expression rightExp) {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Predicate predicate = ExpressionToPredicateAdapter.toPredicate((Expression)leftExp);
                predicate = PredicateBuilder.or(predicate, ExpressionToPredicateAdapter.toPredicate((Expression)rightExp));
                boolean answer = predicate.matches(exchange);
                return (T)exchange.getContext().getTypeConverter().convertTo(type, (Object)answer);
            }

            public String toString() {
                return LogicalExpression.this.left + " " + LogicalExpression.this.token.getText() + " " + LogicalExpression.this.right;
            }
        };
    }
}

