/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import org.apache.camel.Expression;
import org.apache.camel.IsSingleton;
import org.apache.camel.Predicate;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@org.apache.camel.spi.annotations.Language(value="bean")
public class BeanLanguage
implements Language,
IsSingleton {
    public static Expression bean(String expression) {
        BeanLanguage language = new BeanLanguage();
        return language.createExpression(expression);
    }

    public static Expression bean(Class<?> beanType, String method) {
        Object bean = org.apache.camel.support.ObjectHelper.newInstance(beanType);
        return BeanLanguage.bean(bean, method);
    }

    public static Expression bean(Object bean, String method) {
        BeanLanguage language = new BeanLanguage();
        return language.createExpression(bean, method);
    }

    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression(String expression) {
        ObjectHelper.notNull((Object)expression, (String)"expression");
        String beanName = expression;
        String method = null;
        if (expression.contains("?method=")) {
            beanName = StringHelper.before((String)expression, (String)"?");
            method = StringHelper.after((String)expression, (String)"?method=");
        } else {
            int doubleColonIndex = expression.indexOf("::");
            int beginOfParameterDeclaration = expression.indexOf("(");
            if (doubleColonIndex > 0 && (expression.indexOf("(") < 0 || doubleColonIndex < beginOfParameterDeclaration)) {
                beanName = expression.substring(0, doubleColonIndex);
                method = expression.substring(doubleColonIndex + 2);
            } else {
                int idx = expression.indexOf(46);
                if (idx > 0) {
                    beanName = expression.substring(0, idx);
                    method = expression.substring(idx + 1);
                }
            }
        }
        return new BeanExpression(beanName, method);
    }

    public Expression createExpression(Object bean, String method) {
        ObjectHelper.notNull((Object)bean, (String)"bean");
        return new BeanExpression(bean, method);
    }

    public boolean isSingleton() {
        return true;
    }
}

