/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.bean;

import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.component.bean.BeanExpressionProcessor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ConstantTypeBeanHolder;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.language.bean.RuntimeBeanExpressionException;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.StringHelper;

public class BeanExpression
implements Expression,
Predicate {
    private final Object bean;
    private final String beanName;
    private final Class<?> type;
    private final String method;
    private volatile BeanHolder beanHolder;

    public BeanExpression(Object bean, String method) {
        this.bean = bean;
        this.method = method;
        this.beanName = null;
        this.type = null;
    }

    public BeanExpression(String beanName, String method) {
        this.beanName = beanName;
        this.method = method;
        this.bean = null;
        this.type = null;
    }

    public BeanExpression(Class<?> type, String method) {
        this.type = type;
        this.method = method;
        this.bean = null;
        this.beanName = null;
    }

    public BeanExpression(BeanHolder beanHolder, String method) {
        this.beanHolder = beanHolder;
        this.method = method;
        this.bean = null;
        this.beanName = null;
        this.type = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BeanExpression[");
        if (this.bean != null) {
            sb.append(this.bean.toString());
        } else if (this.beanName != null) {
            sb.append(this.beanName);
        } else if (this.type != null) {
            sb.append(ObjectHelper.className(this.type));
        }
        if (this.method != null) {
            sb.append(" method:").append(this.method);
        }
        sb.append("]");
        return sb.toString();
    }

    public Object evaluate(Exchange exchange) {
        if (this.beanHolder == null) {
            this.beanHolder = this.createBeanHolder(exchange.getContext());
        }
        if (OgnlHelper.isInvalidValidOgnlExpression((String)this.method)) {
            ExpressionIllegalSyntaxException cause = new ExpressionIllegalSyntaxException(this.method);
            throw new RuntimeBeanExpressionException(exchange, this.beanName, this.method, (Throwable)cause);
        }
        if (OgnlHelper.isValidOgnlExpression((String)this.method)) {
            try {
                return BeanExpression.invokeOgnlMethod(this.beanHolder, this.beanName, this.method, exchange);
            }
            catch (Exception e) {
                if (e instanceof RuntimeBeanExpressionException) {
                    throw (RuntimeBeanExpressionException)((Object)e);
                }
                throw new RuntimeBeanExpressionException(exchange, BeanExpression.getBeanName(this.beanName, this.beanHolder), this.method, e);
            }
        }
        try {
            return BeanExpression.invokeBean(this.beanHolder, this.beanName, this.method, exchange);
        }
        catch (Exception e) {
            if (e instanceof RuntimeBeanExpressionException) {
                throw (RuntimeBeanExpressionException)((Object)e);
            }
            throw new RuntimeBeanExpressionException(exchange, BeanExpression.getBeanName(this.beanName, this.beanHolder), this.method, e);
        }
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        Object result = this.evaluate(exchange);
        if (Object.class == type) {
            return (T)result;
        }
        return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, result);
    }

    public boolean matches(Exchange exchange) {
        Object value = this.evaluate(exchange);
        return ObjectHelper.evaluateValuePredicate((Object)value);
    }

    private synchronized BeanHolder createBeanHolder(CamelContext context) {
        BeanHolder holder;
        if (this.bean != null) {
            holder = new ConstantBeanHolder(this.bean, context);
        } else if (this.beanName != null) {
            holder = new RegistryBean(context, this.beanName);
        } else if (this.type != null) {
            holder = new ConstantTypeBeanHolder(this.type, context);
        } else {
            throw new IllegalArgumentException("Either bean, beanName or type should be set on " + this);
        }
        return holder;
    }

    private static String getBeanName(String beanName, BeanHolder beanHolder) {
        String name = beanName;
        if (name == null && beanHolder != null && beanHolder.getBean() != null) {
            name = beanHolder.getBean().getClass().getCanonicalName();
        }
        if (name == null && beanHolder != null && beanHolder.getBeanInfo() != null && beanHolder.getBeanInfo().getType() != null) {
            name = beanHolder.getBeanInfo().getType().getCanonicalName();
        }
        return name;
    }

    private static Object invokeBean(BeanHolder beanHolder, String beanName, String methodName, Exchange exchange) {
        Object result;
        BeanExpressionProcessor processor = new BeanExpressionProcessor(beanHolder);
        if (methodName != null) {
            processor.setMethod(methodName);
            processor.setShorthandMethod(true);
        }
        try {
            Exchange resultExchange = ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
            resultExchange.setException(null);
            resultExchange.setPattern(ExchangePattern.InOut);
            processor.process(resultExchange);
            result = resultExchange.getOut().getBody();
            if (resultExchange.hasProperties()) {
                exchange.getProperties().putAll(resultExchange.getProperties());
            }
            if (resultExchange.getOut().hasHeaders()) {
                exchange.getIn().getHeaders().putAll(resultExchange.getOut().getHeaders());
            }
            if (resultExchange.getException() != null) {
                exchange.setException((Throwable)resultExchange.getException());
            }
        }
        catch (Throwable e) {
            throw new RuntimeBeanExpressionException(exchange, beanName, methodName, e);
        }
        return result;
    }

    private static Object invokeOgnlMethod(BeanHolder beanHolder, String beanName, String ognl, Exchange exchange) {
        Object result = beanHolder.getBean();
        Exchange resultExchange = ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
        resultExchange.setException(null);
        resultExchange.setPattern(ExchangePattern.InOut);
        resultExchange.getIn().removeHeader("CamelBeanMethodName");
        String ognlPath = "";
        Object beanToCall = beanHolder.getBean();
        Class<?> beanType = beanHolder.getBeanInfo().getType();
        if (beanToCall == null && beanType == null) {
            throw new IllegalArgumentException("Bean instance and bean type is null. OGNL bean expressions requires to have either a bean instance of the class name of the bean to use.");
        }
        if (ognl != null) {
            OgnlHelper.validateMethodName((String)ognl);
        }
        List methods = OgnlHelper.splitOgnl((String)ognl);
        for (String methodName : methods) {
            BeanHolder holder = beanToCall != null ? new ConstantBeanHolder(beanToCall, exchange.getContext()) : (beanType != null ? new ConstantTypeBeanHolder(beanType, exchange.getContext()) : null);
            boolean nullSafe = OgnlHelper.isNullSafeOperator((String)methodName);
            if (holder == null) {
                String name = BeanExpression.getBeanName(null, beanHolder);
                throw new RuntimeBeanExpressionException(exchange, name, ognl, "last method returned null and therefore cannot continue to invoke method " + methodName + " on a null instance");
            }
            ognlPath = ognlPath + methodName;
            methodName = OgnlHelper.removeLeadingOperators((String)methodName);
            String key = null;
            KeyValueHolder index = OgnlHelper.isOgnlIndex((String)methodName);
            if (index != null) {
                methodName = (String)index.getKey();
                key = (String)index.getValue();
            }
            if (methodName != null) {
                Object newResult = BeanExpression.invokeBean(holder, beanName, methodName, resultExchange);
                if (resultExchange.getException() != null) {
                    throw new RuntimeBeanExpressionException(exchange, beanName, methodName, resultExchange.getException());
                }
                result = newResult;
            }
            if (key != null) {
                if (SimpleLanguage.hasSimpleFunction(key)) {
                    key = (String)SimpleLanguage.expression(key).evaluate(exchange, String.class);
                }
                if (key != null) {
                    result = BeanExpression.lookupResult(resultExchange, key, result, nullSafe, ognlPath, holder.getBean());
                }
            }
            if (result == null && nullSafe) {
                return null;
            }
            beanToCall = result;
            beanType = null;
        }
        return result;
    }

    private static Object lookupResult(Exchange exchange, String key, Object result, boolean nullSafe, String ognlPath, Object bean) {
        List list;
        boolean checkList;
        StringHelper.notEmpty((String)key, (String)"key", (Object)("in Simple language ognl path: " + ognlPath));
        key = key.trim();
        key = StringHelper.removeLeadingAndEndingQuotes((String)key);
        Map map = (Map)exchange.getContext().getTypeConverter().convertTo(Map.class, result);
        if (map != null) {
            return map.get(key);
        }
        Integer num = (Integer)exchange.getContext().getTypeConverter().tryConvertTo(Integer.class, (Object)key);
        boolean bl = checkList = key.startsWith("last") || num != null;
        if (checkList && (list = (List)exchange.getContext().getTypeConverter().convertTo(List.class, result)) != null) {
            if (key.startsWith("last")) {
                num = list.size() - 1;
                String after = StringHelper.after((String)key, (String)"-");
                if (after != null) {
                    Integer redux = (Integer)exchange.getContext().getTypeConverter().tryConvertTo(Integer.class, (Object)after.trim());
                    if (redux != null) {
                        num = num - redux;
                    } else {
                        throw new ExpressionIllegalSyntaxException(key);
                    }
                }
            }
            if (num != null && num >= 0 && list.size() > num - 1 && list.size() > 0) {
                return list.get(num);
            }
            if (!nullSafe) {
                throw new IndexOutOfBoundsException("Index: " + num + ", Size: " + list.size() + " out of bounds with List from bean: " + bean + "using OGNL path [" + ognlPath + "]");
            }
        }
        if (!nullSafe) {
            throw new IndexOutOfBoundsException("Key: " + key + " not found in bean: " + bean + " of type: " + ObjectHelper.classCanonicalName((Object)bean) + " using OGNL path [" + ognlPath + "]");
        }
        return null;
    }
}

