/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.camel.Exchange;
import org.apache.camel.converter.stream.OutputStreamBuilder;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;

@Dataformat(value="zip")
public class ZipDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private int compressionLevel;

    public ZipDataFormat() {
        this.compressionLevel = 1;
    }

    public ZipDataFormat(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public String getDataFormatName() {
        return "zip";
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        Deflater deflater = new Deflater(this.compressionLevel);
        DeflaterOutputStream zipOutput = new DeflaterOutputStream(stream, deflater);
        try {
            IOHelper.copy((InputStream)is, (OutputStream)zipOutput);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{is, zipOutput});
            deflater.end();
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{is, zipOutput});
        deflater.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Object object;
        InflaterInputStream inflaterInputStream = new InflaterInputStream(inputStream);
        OutputStreamBuilder osb = OutputStreamBuilder.withExchange((Exchange)exchange);
        try {
            IOHelper.copy((InputStream)inflaterInputStream, (OutputStream)osb);
            object = osb.build();
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{osb, inflaterInputStream, inputStream});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{osb, inflaterInputStream, inputStream});
        return object;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

