/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="string")
public class StringDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private String charset;

    public StringDataFormat() {
    }

    public StringDataFormat(String charset) {
        this.charset = charset;
    }

    public String getDataFormatName() {
        return "string";
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws IOException {
        String text = (String)ExchangeHelper.convertToType((Exchange)exchange, String.class, (Object)graph);
        byte[] bytes = this.charset != null ? text.getBytes(this.charset) : text.getBytes();
        stream.write(bytes);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        byte[] bytes = (byte[])ExchangeHelper.convertToType((Exchange)exchange, byte[].class, (Object)stream);
        String answer = this.charset != null ? new String(bytes, this.charset) : new String(bytes);
        return answer;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

