/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Channel;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.Service;
import org.apache.camel.impl.AbstractCamelContext;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.ChildServiceSupport;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.MDC;

public class RouteService
extends ChildServiceSupport {
    private final AbstractCamelContext camelContext;
    private final RouteDefinition routeDefinition;
    private final List<RouteContext> routeContexts;
    private final List<Route> routes;
    private final String id;
    private boolean removingRoutes;
    private final Map<Route, Consumer> inputs = new HashMap<Route, Consumer>();
    private final AtomicBoolean warmUpDone = new AtomicBoolean(false);
    private final AtomicBoolean endpointDone = new AtomicBoolean(false);

    public RouteService(AbstractCamelContext camelContext, RouteDefinition routeDefinition, List<RouteContext> routeContexts, List<Route> routes) {
        this.camelContext = camelContext;
        this.routeDefinition = routeDefinition;
        this.routeContexts = routeContexts;
        this.routes = routes;
        this.id = routeDefinition.idOrCreate(camelContext.getNodeIdFactory());
    }

    public String getId() {
        return this.id;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public List<RouteContext> getRouteContexts() {
        return this.routeContexts;
    }

    public RouteDefinition getRouteDefinition() {
        return this.routeDefinition;
    }

    public Collection<Route> getRoutes() {
        return this.routes;
    }

    public Set<Endpoint> gatherEndpoints() {
        LinkedHashSet<Endpoint> answer = new LinkedHashSet<Endpoint>();
        for (Route route : this.routes) {
            Set<Service> services = this.gatherChildServices(route, true);
            for (Service service : services) {
                Endpoint endpoint;
                if (!(service instanceof EndpointAware) || (endpoint = ((EndpointAware)service).getEndpoint()) == null) continue;
                answer.add(endpoint);
            }
        }
        return answer;
    }

    public Map<Route, Consumer> getInputs() {
        return this.inputs;
    }

    public boolean isRemovingRoutes() {
        return this.removingRoutes;
    }

    public void setRemovingRoutes(boolean removingRoutes) {
        this.removingRoutes = removingRoutes;
    }

    public void warmUp() throws Exception {
        try {
            this.doWarmUp();
        }
        catch (Exception e) {
            throw new FailedToCreateRouteException(this.routeDefinition.getId(), RouteDefinitionHelper.getRouteMessage(this.routeDefinition.toString()), (Throwable)e);
        }
    }

    protected synchronized void doWarmUp() throws Exception {
        if (this.endpointDone.compareAndSet(false, true)) {
            for (Route route : this.routes) {
                ServiceHelper.startService((Object)route.getEndpoint());
            }
        }
        if (this.warmUpDone.compareAndSet(false, true)) {
            for (Route route : this.routes) {
                MDCHelper mdcHelper = new MDCHelper(route.getId());
                Throwable throwable = null;
                try {
                    route.warmUp();
                    this.log.debug("Starting services on route: {}", (Object)route.getId());
                    List services = route.getServices();
                    route.onStartingServices(services);
                    LinkedHashSet list = new LinkedHashSet();
                    for (Service service : services) {
                        list.addAll(ServiceHelper.getChildServices((Service)service));
                    }
                    ArrayList<Service> childServices = new ArrayList<Service>();
                    for (Service service : list) {
                        if (service instanceof RouteAware) {
                            ((RouteAware)service).setRoute(route);
                        }
                        if (service instanceof Consumer) {
                            this.inputs.put(route, (Consumer)service);
                            continue;
                        }
                        childServices.add(service);
                    }
                    this.startChildService(route, childServices);
                    EventHelper.notifyRouteAdded((CamelContext)this.camelContext, (Route)route);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (mdcHelper == null) continue;
                    if (throwable != null) {
                        try {
                            mdcHelper.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    mdcHelper.close();
                }
            }
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesAdd(this.routes);
            }
            this.camelContext.addRouteCollection(this.routes);
            for (Route route : this.routes) {
                this.camelContext.getInflightRepository().addRoute(route.getId());
            }
        }
    }

    protected void doStart() throws Exception {
        this.warmUp();
        for (Route route : this.routes) {
            MDCHelper mdcHelper = new MDCHelper(route.getId());
            Throwable throwable = null;
            try {
                ServiceHelper.startService((Object)route);
                if (route.getRouteContext().getRoutePolicyList() != null) {
                    for (RoutePolicy routePolicy : route.getRouteContext().getRoutePolicyList()) {
                        routePolicy.onStart(route);
                    }
                }
                EventHelper.notifyRouteStarted((CamelContext)this.camelContext, (Route)route);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (mdcHelper == null) continue;
                if (throwable != null) {
                    try {
                        mdcHelper.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                mdcHelper.close();
            }
        }
    }

    protected void doStop() throws Exception {
        boolean isShutdownCamelContext = this.camelContext.isStopping();
        if (isShutdownCamelContext || this.isRemovingRoutes()) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesRemove(this.routes);
            }
        }
        for (Route route : this.routes) {
            MDCHelper mdcHelper = new MDCHelper(route.getId());
            Throwable throwable = null;
            try {
                this.log.debug("Stopping services on route: {}", (Object)route.getId());
                Set<Service> services = this.gatherChildServices(route, true);
                this.stopChildService(route, services, isShutdownCamelContext);
                if (isShutdownCamelContext) {
                    ServiceHelper.stopAndShutdownServices((Object[])new Object[]{route});
                } else {
                    ServiceHelper.stopService((Object)route);
                }
                if (route.getRouteContext().getRoutePolicyList() != null) {
                    for (RoutePolicy routePolicy : route.getRouteContext().getRoutePolicyList()) {
                        routePolicy.onStop(route);
                    }
                }
                EventHelper.notifyRouteStopped((CamelContext)this.camelContext, (Route)route);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (mdcHelper == null) continue;
                if (throwable != null) {
                    try {
                        mdcHelper.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                mdcHelper.close();
            }
        }
        if (this.isRemovingRoutes()) {
            this.camelContext.removeRouteCollection(this.routes);
        }
        this.warmUpDone.set(false);
    }

    protected void doShutdown() throws Exception {
        for (Route route : this.routes) {
            MDCHelper mdcHelper = new MDCHelper(route.getId());
            Throwable throwable = null;
            try {
                this.log.debug("Shutting down services on route: {}", (Object)route.getId());
                Set<Service> services = this.gatherChildServices(route, true);
                this.stopChildService(route, services, true);
                ServiceHelper.stopAndShutdownServices((Object[])new Object[]{route});
                ServiceHelper.stopAndShutdownServices((Object[])new Object[]{route.getEndpoint()});
                if (route.getRouteContext().getRoutePolicyList() != null) {
                    for (RoutePolicy routePolicy : route.getRouteContext().getRoutePolicyList()) {
                        routePolicy.onRemove(route);
                    }
                }
                EventHelper.notifyRouteRemoved((CamelContext)this.camelContext, (Route)route);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (mdcHelper == null) continue;
                if (throwable != null) {
                    try {
                        mdcHelper.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                mdcHelper.close();
            }
        }
        for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
            strategy.onRoutesRemove(this.routes);
        }
        for (Route route : this.routes) {
            this.camelContext.getInflightRepository().removeRoute(route.getId());
        }
        this.camelContext.removeRouteCollection(this.routes);
        this.inputs.clear();
        this.warmUpDone.set(false);
        this.endpointDone.set(false);
    }

    protected void doSuspend() throws Exception {
        for (Route route : this.routes) {
            MDCHelper mdcHelper = new MDCHelper(route.getId());
            Throwable throwable = null;
            try {
                if (route.getRouteContext().getRoutePolicyList() == null) continue;
                for (RoutePolicy routePolicy : route.getRouteContext().getRoutePolicyList()) {
                    routePolicy.onSuspend(route);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (mdcHelper == null) continue;
                if (throwable != null) {
                    try {
                        mdcHelper.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                mdcHelper.close();
            }
        }
    }

    protected void doResume() throws Exception {
        for (Route route : this.routes) {
            MDCHelper mdcHelper = new MDCHelper(route.getId());
            Throwable throwable = null;
            try {
                if (route.getRouteContext().getRoutePolicyList() == null) continue;
                for (RoutePolicy routePolicy : route.getRouteContext().getRoutePolicyList()) {
                    routePolicy.onResume(route);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (mdcHelper == null) continue;
                if (throwable != null) {
                    try {
                        mdcHelper.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                mdcHelper.close();
            }
        }
    }

    protected void startChildService(Route route, List<Service> services) throws Exception {
        for (Service service : services) {
            this.log.debug("Starting child service on route: {} -> {}", (Object)route.getId(), (Object)service);
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onServiceAdd((CamelContext)this.camelContext, service, route);
            }
            ServiceHelper.startService((Object)service);
            this.addChildService(service);
        }
    }

    protected void stopChildService(Route route, Set<Service> services, boolean shutdown) throws Exception {
        for (Service service : services) {
            this.log.debug("{} child service on route: {} -> {}", new Object[]{shutdown ? "Shutting down" : "Stopping", route.getId(), service});
            if (service instanceof ErrorHandler) {
                for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                    RouteDefinition definition = (RouteDefinition)route.getRouteContext().getRoute();
                    strategy.onErrorHandlerRemove(route.getRouteContext(), (Processor)service, definition.getErrorHandlerBuilder());
                }
            } else {
                for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                    strategy.onServiceRemove((CamelContext)this.camelContext, service, route);
                }
            }
            if (shutdown) {
                ServiceHelper.stopAndShutdownService((Object)service);
            } else {
                ServiceHelper.stopService((Object)service);
            }
            this.removeChildService(service);
        }
    }

    private Set<Service> gatherChildServices(Route route, boolean includeErrorHandler) {
        ArrayList<Service> services = new ArrayList<Service>();
        services.addAll(route.getServices());
        this.doGetRouteScopedServices(services, route);
        LinkedHashSet<Service> list = new LinkedHashSet<Service>();
        for (Service service : services) {
            list.addAll(ServiceHelper.getChildServices((Service)service));
        }
        if (includeErrorHandler) {
            this.doGetRouteScopedErrorHandler(list, route);
        }
        LinkedHashSet<Service> answer = new LinkedHashSet<Service>();
        answer.addAll(list);
        return answer;
    }

    private void doGetRouteScopedErrorHandler(Set<Service> services, Route route) {
        boolean includeErrorHandler = !this.routeDefinition.isContextScopedErrorHandler(route.getRouteContext().getCamelContext());
        ArrayList<Service> extra = new ArrayList<Service>();
        if (includeErrorHandler) {
            for (Service service : services) {
                Processor eh;
                if (!(service instanceof Channel) || !((eh = ((Channel)service).getErrorHandler()) instanceof Service)) continue;
                extra.add((Service)eh);
            }
        }
        if (!extra.isEmpty()) {
            services.addAll(extra);
        }
    }

    private void doGetRouteScopedServices(List<Service> services, Route route) {
        RouteDefinition definition = (RouteDefinition)route.getRouteContext().getRoute();
        for (ProcessorDefinition<?> output : definition.getOutputs()) {
            Processor onCompletionProcessor;
            OnCompletionDefinition onCompletionDefinition;
            if (output instanceof OnExceptionDefinition) {
                Processor errorHandler;
                OnExceptionDefinition onExceptionDefinition = (OnExceptionDefinition)output;
                if (!onExceptionDefinition.isRouteScoped() || !((errorHandler = onExceptionDefinition.getErrorHandler(route.getId())) instanceof Service)) continue;
                services.add((Service)errorHandler);
                continue;
            }
            if (!(output instanceof OnCompletionDefinition) || !(onCompletionDefinition = (OnCompletionDefinition)output).isRouteScoped() || !((onCompletionProcessor = onCompletionDefinition.getOnCompletion(route.getId())) instanceof Service)) continue;
            services.add((Service)onCompletionProcessor);
        }
    }

    class MDCHelper
    implements AutoCloseable {
        final Map<String, String> originalContextMap;

        MDCHelper(String routeId) {
            if (RouteService.this.getCamelContext().isUseMDCLogging().booleanValue()) {
                this.originalContextMap = MDC.getCopyOfContextMap();
                MDC.put((String)"camel.contextId", (String)RouteService.this.getCamelContext().getName());
                MDC.put((String)"camel.routeId", (String)routeId);
            } else {
                this.originalContextMap = null;
            }
        }

        @Override
        public void close() {
            if (RouteService.this.getCamelContext().isUseMDCLogging().booleanValue()) {
                if (this.originalContextMap != null) {
                    MDC.setContextMap(this.originalContextMap);
                } else {
                    MDC.clear();
                }
            }
        }
    }
}

