/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.support.service.ServiceSupport;

@ManagedResource(description="Memory based state repository")
public class MemoryStateRepository
extends ServiceSupport
implements StateRepository<String, String> {
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();

    @ManagedOperation(description="Adds the value of the given key to the store")
    public void setState(String key, String value) {
        this.cache.put(key, value);
    }

    @ManagedOperation(description="Gets the value of the given key from store")
    public String getState(String key) {
        return (String)this.cache.get(key);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        this.cache.clear();
    }
}

