/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.impl.ReloadStrategySupport;
import org.apache.camel.processor.UnitOfWorkProducer;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;

@ManagedResource(description="Managed FileWatcherReloadStrategy")
public class FileWatcherReloadStrategy
extends ReloadStrategySupport {
    private String folder;
    private boolean isRecursive;
    private long delay = 500L;
    private Processor task;
    private Endpoint endpoint;
    private Consumer consumer;

    public FileWatcherReloadStrategy() {
        this.setRecursive(false);
    }

    public FileWatcherReloadStrategy(String directory) {
        this.setFolder(directory);
        this.setRecursive(false);
    }

    public FileWatcherReloadStrategy(String directory, boolean isRecursive) {
        this.setFolder(directory);
        this.setRecursive(isRecursive);
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setRecursive(boolean isRecursive) {
        this.isRecursive = isRecursive;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    @ManagedAttribute(description="Folder being watched")
    public String getFolder() {
        return this.folder;
    }

    @ManagedAttribute(description="Whether the reload strategy watches directory recursively")
    public boolean isRecursive() {
        return this.isRecursive;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.folder == null) {
            return;
        }
        File dir = new File(this.folder);
        if (dir.exists() && dir.isDirectory()) {
            this.log.info("Starting ReloadStrategy to watch directory: {}", (Object)dir);
            this.endpoint = this.getCamelContext().getEndpoint("file:" + dir + "?delay=" + this.delay + "&recursive=" + this.isRecursive + "&include=.*xml$&readLock=none&noop=true&idempotentKey=${file:name}-${file:modified}");
            this.task = new UnitOfWorkProducer((Producer)new UpdatedFileProcessor(this.endpoint));
            this.consumer = this.endpoint.createConsumer(this.task);
            ServiceHelper.startService((Object)this.endpoint);
            ServiceHelper.startService((Object)this.consumer);
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.consumer != null) {
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.consumer});
            this.getCamelContext().removeService((Object)this.consumer);
        }
        if (this.endpoint != null) {
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.endpoint});
            this.getCamelContext().removeEndpoint(this.endpoint);
        }
    }

    private final class UpdatedFileProcessor
    extends DefaultProducer {
        private UpdatedFileProcessor(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(Exchange exchange) throws Exception {
            String name = (String)exchange.getMessage().getHeader("CamelFileName", String.class);
            this.log.debug("Modified/Created file: {}", (Object)name);
            try {
                InputStream is = (InputStream)exchange.getMessage().getMandatoryBody(InputStream.class);
                FileWatcherReloadStrategy.this.onReloadXml(FileWatcherReloadStrategy.this.getCamelContext(), name, is);
                IOHelper.close((Closeable)is);
            }
            catch (Exception e) {
                this.log.warn("Error reloading routes from file: " + name + " due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
            }
        }
    }
}

