/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.AbstractDynamicRegistry;
import org.apache.camel.impl.transformer.TransformerKey;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.reifier.transformer.TransformerReifier;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class DefaultTransformerRegistry
extends AbstractDynamicRegistry<TransformerKey, Transformer>
implements TransformerRegistry<TransformerKey> {
    private final Map<TransformerKey, TransformerKey> aliasMap = new ConcurrentHashMap<TransformerKey, TransformerKey>();

    public DefaultTransformerRegistry(CamelContext context) throws Exception {
        this(context, new ArrayList<TransformerDefinition>());
    }

    public DefaultTransformerRegistry(CamelContext context, List<TransformerDefinition> definitions) throws Exception {
        super(context, CamelContextHelper.getMaximumTransformerCacheSize((CamelContext)context));
        for (TransformerDefinition def : definitions) {
            Transformer transformer = TransformerReifier.reifier(def).createTransformer(context);
            context.addService((Object)transformer);
            this.put(this.createKey(def), transformer);
        }
    }

    public Transformer resolveTransformer(TransformerKey key) {
        if (ObjectHelper.isEmpty((Object)key.getScheme()) && key.getTo() == null) {
            return null;
        }
        Transformer answer = (Transformer)this.get((Object)this.aliasMap.getOrDefault((Object)key, key));
        if (answer != null || ObjectHelper.isNotEmpty((Object)key.getScheme())) {
            return answer;
        }
        TransformerKey alias = null;
        if (key.getFrom() != null && ObjectHelper.isNotEmpty((Object)key.getFrom().getName())) {
            alias = new TransformerKey(new DataType(key.getFrom().getModel()), key.getTo());
            answer = (Transformer)this.get((Object)alias);
        }
        if (answer == null && ObjectHelper.isNotEmpty((Object)key.getTo().getName())) {
            alias = new TransformerKey(key.getFrom(), new DataType(key.getTo().getModel()));
            answer = (Transformer)this.get((Object)alias);
        }
        if (answer == null && key.getFrom() != null && ObjectHelper.isNotEmpty((Object)key.getFrom().getName()) && ObjectHelper.isNotEmpty((Object)key.getTo().getName())) {
            alias = new TransformerKey(new DataType(key.getFrom().getModel()), new DataType(key.getTo().getModel()));
            answer = (Transformer)this.get((Object)alias);
        }
        if (answer == null && key.getFrom() != null) {
            alias = new TransformerKey(key.getFrom().getModel());
            answer = (Transformer)this.get((Object)alias);
        }
        if (answer == null) {
            alias = new TransformerKey(key.getTo().getModel());
            answer = (Transformer)this.get((Object)alias);
        }
        if (answer != null) {
            this.aliasMap.put(key, alias);
        }
        return answer;
    }

    @Override
    public boolean isStatic(String scheme) {
        return this.isStatic(new TransformerKey(scheme));
    }

    public boolean isStatic(DataType from, DataType to) {
        return this.isStatic(new TransformerKey(from, to));
    }

    @Override
    public boolean isDynamic(String scheme) {
        return this.isDynamic(new TransformerKey(scheme));
    }

    public boolean isDynamic(DataType from, DataType to) {
        return this.isDynamic(new TransformerKey(from, to));
    }

    @Override
    public String toString() {
        return "TransformerRegistry for " + this.context.getName() + ", capacity: " + this.maxCacheSize;
    }

    private TransformerKey createKey(TransformerDefinition def) {
        return ObjectHelper.isNotEmpty((Object)def.getScheme()) ? new TransformerKey(def.getScheme()) : new TransformerKey(new DataType(def.getFromType()), new DataType(def.getToType()));
    }
}

