/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.NamedNode;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.CamelInternalProcessorAdvice;
import org.apache.camel.processor.ContractAdvice;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.reifier.RouteReifier;
import org.apache.camel.reifier.rest.RestBindingReifier;
import org.apache.camel.spi.Contract;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteError;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.CamelContextHelper;

public class DefaultRouteContext
implements RouteContext {
    private final Map<NamedNode, AtomicInteger> nodeIndex = new HashMap<NamedNode, AtomicInteger>();
    private final RouteDefinition route;
    private FromDefinition from;
    private final Collection<Route> routes;
    private Endpoint endpoint;
    private final List<Processor> eventDrivenProcessors = new ArrayList<Processor>();
    private CamelContext camelContext;
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private ManagementInterceptStrategy managementInterceptStrategy;
    private boolean routeAdded;
    private Boolean trace;
    private Boolean messageHistory;
    private Boolean logMask;
    private Boolean logExhaustedMessageBody;
    private Boolean streamCache;
    private Boolean handleFault;
    private Long delay;
    private Boolean autoStartup = Boolean.TRUE;
    private List<RoutePolicy> routePolicyList = new ArrayList<RoutePolicy>();
    private ShutdownRoute shutdownRoute;
    private ShutdownRunningTask shutdownRunningTask;
    private RouteError routeError;
    private RouteController routeController;

    public DefaultRouteContext(CamelContext camelContext, RouteDefinition route, FromDefinition from, Collection<Route> routes) {
        this.camelContext = camelContext;
        this.route = route;
        this.from = from;
        this.routes = routes;
    }

    public DefaultRouteContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.routes = new ArrayList<Route>();
        this.route = new RouteDefinition("temporary");
    }

    public Endpoint getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = this.from.resolveEndpoint(this);
        }
        return this.endpoint;
    }

    public FromDefinition getFrom() {
        return this.from;
    }

    public RouteDefinition getRoute() {
        return this.route;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Endpoint resolveEndpoint(String uri) {
        return new RouteReifier(this.route).resolveEndpoint(this.getCamelContext(), uri);
    }

    public Endpoint resolveEndpoint(String uri, String ref) {
        Endpoint endpoint = null;
        if (uri != null && (endpoint = this.resolveEndpoint(uri)) == null) {
            throw new NoSuchEndpointException(uri);
        }
        if (ref != null) {
            endpoint = this.lookup(ref, Endpoint.class);
            if (endpoint == null) {
                throw new NoSuchEndpointException("ref:" + ref, "check your camel registry with id " + ref);
            }
            if (!this.getCamelContext().equals(endpoint.getCamelContext())) {
                throw new NoSuchEndpointException("ref:" + ref, "make sure the endpoint has the same camel context as the route does.");
            }
            try {
                this.getCamelContext().addService((Object)endpoint);
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Either 'uri' or 'ref' must be specified on: " + this);
        }
        return endpoint;
    }

    public <T> T lookup(String name, Class<T> type) {
        return (T)this.getCamelContext().getRegistry().lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.getCamelContext().getRegistry().findByTypeWithName(type);
    }

    public <T> T mandatoryLookup(String name, Class<T> type) {
        return (T)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)name, type);
    }

    public void commit() {
        if (!this.eventDrivenProcessors.isEmpty()) {
            CamelInternalProcessor.RouteLifecycleAdvice task2;
            CamelInternalProcessor.RoutePolicyAdvice task;
            Processor target = Pipeline.newInstance(this.getCamelContext(), this.eventDrivenProcessors);
            String routeId = this.route.idOrCreate(this.getCamelContext().getNodeIdFactory());
            CamelInternalProcessor internal = new CamelInternalProcessor(target);
            internal.addAdvice(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(this));
            List<RoutePolicy> routePolicyList = this.getRoutePolicyList();
            if (routePolicyList != null && !routePolicyList.isEmpty()) {
                for (RoutePolicy policy : routePolicyList) {
                    if (this.camelContext.hasService((Object)policy)) continue;
                    try {
                        this.camelContext.addService((Object)policy);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                }
                internal.addAdvice(new CamelInternalProcessor.RoutePolicyAdvice(routePolicyList));
            }
            internal.addAdvice(new CamelInternalProcessor.RouteInflightRepositoryAdvice(this.camelContext.getInflightRepository(), routeId));
            if (this.managementInterceptStrategy != null) {
                internal.addAdvice(CamelInternalProcessorAdvice.wrap(this.managementInterceptStrategy.createProcessor("route")));
            }
            internal.addAdvice(new CamelInternalProcessor.RouteLifecycleAdvice());
            if (this.route.getRestBindingDefinition() != null) {
                try {
                    internal.addAdvice(new RestBindingReifier(this.route.getRestBindingDefinition()).createRestBindingAdvice(this));
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
            if (this.route.getInputType() != null || this.route.getOutputType() != null) {
                Contract contract = new Contract();
                if (this.route.getInputType() != null) {
                    contract.setInputType(this.route.getInputType().getUrn());
                    contract.setValidateInput(this.route.getInputType().isValidate());
                }
                if (this.route.getOutputType() != null) {
                    contract.setOutputType(this.route.getOutputType().getUrn());
                    contract.setValidateOutput(this.route.getOutputType().isValidate());
                }
                internal.addAdvice(new ContractAdvice(contract));
                this.camelContext.setUseDataType(Boolean.valueOf(true));
            }
            EventDrivenConsumerRoute edcr = new EventDrivenConsumerRoute((RouteContext)this, this.getEndpoint(), (Processor)internal);
            edcr.getProperties().put("id", routeId);
            edcr.getProperties().put("parent", Integer.toHexString(this.route.hashCode()));
            edcr.getProperties().put("description", this.route.getDescriptionText());
            if (this.route.getGroup() != null) {
                edcr.getProperties().put("group", this.route.getGroup());
            }
            String rest = "false";
            if (this.route.isRest() != null && this.route.isRest().booleanValue()) {
                rest = "true";
            }
            edcr.getProperties().put("rest", rest);
            List<PropertyDefinition> properties = this.route.getRouteProperties();
            if (properties != null) {
                String[] reservedProperties = new String[]{"id", "parent", "group", "rest", "description"};
                for (PropertyDefinition prop : properties) {
                    try {
                        String key = CamelContextHelper.parseText((CamelContext)this.camelContext, (String)prop.getKey());
                        String val = CamelContextHelper.parseText((CamelContext)this.camelContext, (String)prop.getValue());
                        for (String property : reservedProperties) {
                            if (!property.equalsIgnoreCase(key)) continue;
                            throw new IllegalArgumentException("Cannot set route property " + property + " as it is a reserved property");
                        }
                        edcr.getProperties().put(key, val);
                    }
                    catch (Exception e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                    }
                }
            }
            if ((task = internal.getAdvice(CamelInternalProcessor.RoutePolicyAdvice.class)) != null) {
                task.setRoute(edcr);
            }
            if ((task2 = internal.getAdvice(CamelInternalProcessor.RouteLifecycleAdvice.class)) != null) {
                task2.setRoute(edcr);
            }
            if (routePolicyList != null && !routePolicyList.isEmpty()) {
                for (RoutePolicy policy : routePolicyList) {
                    policy.onInit((Route)edcr);
                }
            }
            this.routes.add(edcr);
        }
    }

    public void addEventDrivenProcessor(Processor processor) {
        this.eventDrivenProcessors.add(processor);
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.getInterceptStrategies().add(interceptStrategy);
    }

    public void setManagementInterceptStrategy(ManagementInterceptStrategy interceptStrategy) {
        this.managementInterceptStrategy = interceptStrategy;
    }

    public ManagementInterceptStrategy getManagementInterceptStrategy() {
        return this.managementInterceptStrategy;
    }

    public boolean isRouteAdded() {
        return this.routeAdded;
    }

    public void setIsRouteAdded(boolean routeAdded) {
        this.routeAdded = routeAdded;
    }

    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    public Boolean isTracing() {
        if (this.trace != null) {
            return this.trace;
        }
        return this.getCamelContext().isTracing();
    }

    public void setMessageHistory(Boolean messageHistory) {
        this.messageHistory = messageHistory;
    }

    public Boolean isMessageHistory() {
        if (this.messageHistory != null) {
            return this.messageHistory;
        }
        return this.getCamelContext().isMessageHistory();
    }

    public void setLogMask(Boolean logMask) {
        this.logMask = logMask;
    }

    public Boolean isLogMask() {
        if (this.logMask != null) {
            return this.logMask;
        }
        return this.getCamelContext().isLogMask();
    }

    public void setLogExhaustedMessageBody(Boolean logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    public Boolean isLogExhaustedMessageBody() {
        if (this.logExhaustedMessageBody != null) {
            return this.logExhaustedMessageBody;
        }
        return this.getCamelContext().isLogExhaustedMessageBody();
    }

    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    public Boolean isStreamCaching() {
        if (this.streamCache != null) {
            return this.streamCache;
        }
        return this.getCamelContext().isStreamCaching();
    }

    public void setHandleFault(Boolean handleFault) {
        this.handleFault = handleFault;
    }

    public Boolean isHandleFault() {
        if (this.handleFault != null) {
            return this.handleFault;
        }
        return this.getCamelContext().isHandleFault();
    }

    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    public Long getDelayer() {
        if (this.delay != null) {
            return this.delay;
        }
        return this.getCamelContext().getDelayer();
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Boolean isAutoStartup() {
        if (this.autoStartup != null) {
            return this.autoStartup;
        }
        return true;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public void setAllowUseOriginalMessage(Boolean allowUseOriginalMessage) {
        this.getCamelContext().setAllowUseOriginalMessage(allowUseOriginalMessage);
    }

    public Boolean isAllowUseOriginalMessage() {
        return this.getCamelContext().isAllowUseOriginalMessage();
    }

    public ShutdownRoute getShutdownRoute() {
        if (this.shutdownRoute != null) {
            return this.shutdownRoute;
        }
        return this.getCamelContext().getShutdownRoute();
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        if (this.shutdownRunningTask != null) {
            return this.shutdownRunningTask;
        }
        return this.getCamelContext().getShutdownRunningTask();
    }

    public int getAndIncrement(NamedNode node) {
        AtomicInteger count = this.nodeIndex.get(node);
        if (count == null) {
            count = new AtomicInteger();
            this.nodeIndex.put(node, count);
        }
        return count.getAndIncrement();
    }

    public void setRoutePolicyList(List<RoutePolicy> routePolicyList) {
        this.routePolicyList = routePolicyList;
    }

    public List<RoutePolicy> getRoutePolicyList() {
        return this.routePolicyList;
    }

    public RouteError getLastError() {
        return this.routeError;
    }

    public void setLastError(RouteError routeError) {
        this.routeError = routeError;
    }

    public RouteController getRouteController() {
        return this.routeController;
    }

    public void setRouteController(RouteController routeController) {
        this.routeController = routeController;
    }
}

