/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultEndpointUtilizationStatistics;
import org.apache.camel.impl.EventNotifierCallback;
import org.apache.camel.impl.ServicePool;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.SharedCamelInternalProcessor;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;

public class DefaultProducerCache
extends ServiceSupport
implements ProducerCache {
    private final CamelContext camelContext;
    private final ServicePool<AsyncProducer> producers;
    private final Object source;
    private final SharedCamelInternalProcessor internalProcessor;
    private EndpointUtilizationStatistics statistics;
    private boolean eventNotifierEnabled = true;
    private boolean extendedStatistics;
    private int maxCacheSize;

    public DefaultProducerCache(Object source, CamelContext camelContext, int cacheSize) {
        this.source = source;
        this.camelContext = camelContext;
        this.maxCacheSize = cacheSize == 0 ? CamelContextHelper.getMaximumCachePoolSize((CamelContext)camelContext) : cacheSize;
        this.producers = new ServicePool<AsyncProducer>(Endpoint::createAsyncProducer, EndpointAware::getEndpoint, this.maxCacheSize);
        this.extendedStatistics = camelContext.getManagementStrategy().getManagementAgent() != null ? camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended() : false;
        this.internalProcessor = new SharedCamelInternalProcessor(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(null));
    }

    public boolean isEventNotifierEnabled() {
        return this.eventNotifierEnabled;
    }

    public void setEventNotifierEnabled(boolean eventNotifierEnabled) {
        this.eventNotifierEnabled = eventNotifierEnabled;
    }

    public boolean isExtendedStatistics() {
        return this.extendedStatistics;
    }

    public void setExtendedStatistics(boolean extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Object getSource() {
        return this.source;
    }

    public AsyncProducer acquireProducer(Endpoint endpoint) {
        try {
            AsyncProducer producer = this.producers.acquire(endpoint);
            if (this.statistics != null) {
                this.statistics.onHit(endpoint.getEndpointUri());
            }
            return producer;
        }
        catch (Throwable e) {
            throw new FailedToCreateProducerException(endpoint, e);
        }
    }

    public void releaseProducer(Endpoint endpoint, AsyncProducer producer) {
        this.producers.release(endpoint, producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange send(Endpoint endpoint, Exchange exchange, Processor resultProcessor) {
        AsyncProducer producer = this.acquireProducer(endpoint);
        try {
            this.log.debug(">>>> {} {}", (Object)endpoint, (Object)exchange);
            exchange.setProperty("CamelToEndpoint", (Object)endpoint.getEndpointUri());
            StopWatch watch = null;
            try {
                boolean sending;
                if (this.eventNotifierEnabled && (sending = EventHelper.notifyExchangeSending((CamelContext)exchange.getContext(), (Exchange)exchange, (Endpoint)endpoint))) {
                    watch = new StopWatch();
                }
                this.internalProcessor.process(exchange, (AsyncProcessor)producer, resultProcessor);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            finally {
                if (this.eventNotifierEnabled && watch != null) {
                    long timeTaken = watch.taken();
                    EventHelper.notifyExchangeSent((CamelContext)exchange.getContext(), (Exchange)exchange, (Endpoint)endpoint, (long)timeTaken);
                }
            }
            Exchange exchange2 = exchange;
            return exchange2;
        }
        finally {
            this.releaseProducer(endpoint, producer);
        }
    }

    public CompletableFuture<Exchange> asyncSend(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor, CompletableFuture<Exchange> future) {
        return this.asyncSendExchange(endpoint, pattern, processor, resultProcessor, null, future);
    }

    public CompletableFuture<Exchange> asyncSendExchange(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor, Exchange exchange, CompletableFuture<Exchange> future) {
        if (exchange == null) {
            exchange = pattern != null ? endpoint.createExchange(pattern) : endpoint.createExchange();
        }
        return this.doAsyncSendExchange(endpoint, processor, resultProcessor, exchange, future);
    }

    protected CompletableFuture<Exchange> doAsyncSendExchange(Endpoint endpoint, Processor processor, Processor resultProcessor, Exchange exchange, CompletableFuture<Exchange> f) {
        CompletableFuture<Exchange> future = f != null ? f : new CompletableFuture<Exchange>();
        ProducerCache.AsyncProducerCallback cb = (p, e, c) -> this.asyncDispatchExchange(endpoint, p, resultProcessor, e, c);
        try {
            if (processor instanceof AsyncProcessor) {
                ((AsyncProcessor)processor).process(exchange, doneSync -> this.doInAsyncProducer(endpoint, exchange, ds -> future.complete(exchange), cb));
            } else {
                if (processor != null) {
                    processor.process(exchange);
                }
                this.doInAsyncProducer(endpoint, exchange, ds -> future.complete(exchange), cb);
            }
        }
        catch (Throwable e2) {
            exchange.setException(e2);
            future.complete(exchange);
        }
        return future;
    }

    public boolean doInAsyncProducer(Endpoint endpoint, Exchange exchange, AsyncCallback callback, ProducerCache.AsyncProducerCallback producerCallback) {
        AsyncProducer producer;
        try {
            producer = this.acquireProducer(endpoint);
            if (producer == null) {
                if (this.isStopped()) {
                    this.log.warn("Ignoring exchange sent after processor is stopped: {}", (Object)exchange);
                    callback.done(true);
                    return true;
                }
                exchange.setException((Throwable)new IllegalStateException("No producer, this processor has not been started: " + (Object)((Object)this)));
                callback.done(true);
                return true;
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        try {
            boolean sending;
            StopWatch watch = this.eventNotifierEnabled && exchange != null ? ((sending = EventHelper.notifyExchangeSending((CamelContext)exchange.getContext(), (Exchange)exchange, (Endpoint)endpoint)) ? new StopWatch() : null) : null;
            return producerCallback.doInAsyncProducer(producer, exchange, doneSync -> {
                try {
                    if (this.eventNotifierEnabled && watch != null) {
                        long timeTaken = watch.taken();
                        EventHelper.notifyExchangeSent((CamelContext)exchange.getContext(), (Exchange)exchange, (Endpoint)endpoint, (long)timeTaken);
                    }
                    this.producers.release(endpoint, producer);
                }
                finally {
                    callback.done(doneSync);
                }
            });
        }
        catch (Throwable e) {
            if (exchange != null) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
    }

    protected boolean asyncDispatchExchange(Endpoint endpoint, AsyncProducer producer, Processor resultProcessor, Exchange exchange, AsyncCallback callback) {
        this.log.debug(">>>> {} {}", (Object)endpoint, (Object)exchange);
        exchange.setProperty("CamelToEndpoint", (Object)endpoint.getEndpointUri());
        try {
            if (this.eventNotifierEnabled) {
                callback = new EventNotifierCallback(callback, exchange, endpoint);
            }
            return this.internalProcessor.process(exchange, callback, (AsyncProcessor)producer, resultProcessor);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected AsyncProducer doGetProducer(Endpoint endpoint) throws Exception {
        return this.producers.acquire(endpoint);
    }

    protected void doStart() throws Exception {
        if (this.extendedStatistics) {
            int max = this.maxCacheSize == 0 ? CamelContextHelper.getMaximumCachePoolSize((CamelContext)this.camelContext) : this.maxCacheSize;
            this.statistics = new DefaultEndpointUtilizationStatistics(max);
        }
        ServiceHelper.startService((Object[])new Object[]{this.producers, this.statistics});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.statistics, this.producers});
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public int size() {
        int size = this.producers.size();
        this.log.trace("size = {}", (Object)size);
        return size;
    }

    public int getCapacity() {
        return this.maxCacheSize;
    }

    public long getHits() {
        return this.producers.getHits();
    }

    public long getMisses() {
        return this.producers.getMisses();
    }

    public long getEvicted() {
        return this.producers.getEvicted();
    }

    public void resetCacheStatistics() {
        this.producers.resetStatistics();
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public synchronized void purge() {
        try {
            this.producers.stop();
            this.producers.start();
        }
        catch (Exception e) {
            this.log.debug("Error restarting producers", (Throwable)e);
        }
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public void cleanUp() {
        this.producers.cleanUp();
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.statistics;
    }

    public String toString() {
        return "ProducerCache for source: " + this.source + ", capacity: " + this.getCapacity();
    }
}

