/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.NamedNode;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.RouteContext;

public class DefaultProcessorFactory
implements ProcessorFactory {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/model/";

    public Processor createChildProcessor(RouteContext routeContext, NamedNode definition, boolean mandatory) throws Exception {
        String name = definition.getClass().getSimpleName();
        FactoryFinder finder = routeContext.getCamelContext().getFactoryFinder(RESOURCE_PATH);
        try {
            Object object;
            if (finder != null && (object = finder.newInstance(name)) instanceof ProcessorFactory) {
                ProcessorFactory pc = (ProcessorFactory)object;
                return pc.createChildProcessor(routeContext, definition, mandatory);
            }
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
            // empty catch block
        }
        return null;
    }

    public Processor createProcessor(RouteContext routeContext, NamedNode definition) throws Exception {
        String name = definition.getClass().getSimpleName();
        FactoryFinder finder = routeContext.getCamelContext().getFactoryFinder(RESOURCE_PATH);
        try {
            Object object;
            if (finder != null && (object = finder.newInstance(name)) instanceof ProcessorFactory) {
                ProcessorFactory pc = (ProcessorFactory)object;
                return pc.createProcessor(routeContext, definition);
            }
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
            // empty catch block
        }
        return null;
    }
}

