/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ShutdownableService;
import org.apache.camel.impl.InterceptSendToEndpointProcessor;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.support.service.ServiceHelper;

public class DefaultInterceptSendToEndpoint
implements InterceptSendToEndpoint,
ShutdownableService {
    private final Endpoint delegate;
    private Processor detour;
    private boolean skip;

    public DefaultInterceptSendToEndpoint(Endpoint destination, boolean skip) {
        this.delegate = destination;
        this.skip = skip;
    }

    public void setDetour(Processor detour) {
        this.detour = detour;
    }

    public Processor getDetour() {
        return this.detour;
    }

    public Endpoint getOriginalEndpoint() {
        return this.delegate;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public String getEndpointUri() {
        return this.delegate.getEndpointUri();
    }

    public String getEndpointKey() {
        return this.delegate.getEndpointKey();
    }

    public Exchange createExchange() {
        return this.delegate.createExchange();
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.delegate.createExchange(pattern);
    }

    public CamelContext getCamelContext() {
        return this.delegate.getCamelContext();
    }

    public Producer createProducer() throws Exception {
        return this.createAsyncProducer();
    }

    public AsyncProducer createAsyncProducer() throws Exception {
        AsyncProducer producer = this.delegate.createAsyncProducer();
        return new InterceptSendToEndpointProcessor(this, this.delegate, producer, this.skip);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return this.delegate.createConsumer(processor);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        return this.delegate.createPollingConsumer();
    }

    public void configureProperties(Map<String, Object> options) {
        this.delegate.configureProperties(options);
    }

    public void setCamelContext(CamelContext context) {
        this.delegate.setCamelContext(context);
    }

    public boolean isLenientProperties() {
        return this.delegate.isLenientProperties();
    }

    public boolean isSingleton() {
        return this.delegate.isSingleton();
    }

    public void start() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.detour, this.delegate});
    }

    public void stop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.delegate, this.detour});
    }

    public void shutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.delegate, this.detour});
    }

    public String toString() {
        return this.delegate.toString();
    }
}

