/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.Injector;
import org.apache.camel.support.ObjectHelper;

public class DefaultInjector
implements Injector {
    private final CamelBeanPostProcessor postProcessor;

    public DefaultInjector(CamelContext context) {
        this.postProcessor = context.getBeanPostProcessor();
    }

    public <T> T newInstance(Class<T> type) {
        Object answer = ObjectHelper.newInstance(type);
        if (answer != null) {
            try {
                this.postProcessor.postProcessBeforeInitialization(answer, answer.getClass().getName());
                this.postProcessor.postProcessAfterInitialization(answer, answer.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error during post processing of bean " + answer, (Throwable)e);
            }
        }
        return (T)answer;
    }

    public boolean supportsAutoWiring() {
        return false;
    }
}

